% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umxHetCor}
\alias{umxHetCor}
\title{umxHetCor}
\usage{
umxHetCor(data, ML = FALSE, use = "complete.obs",
  treatAllAsFactor = FALSE, verbose = FALSE)
}
\arguments{
\item{data}{A \code{\link{data.frame}} of columns for which to compute heterochoric correlations}

\item{ML}{Whether to use Maximum likelihood computation of correlations (default = FALSE)}

\item{use}{How to handle missing data: "complete.obs", "pairwise.complete.obs" Default is complete.obs}

\item{treatAllAsFactor}{Whether to treat all columns as factors, whether they are or not.}

\item{verbose}{How much to tell the user about what was done.}
}
\value{
- A matrix of correlations
}
\description{
umxHetCor Helper to return just the correlations from John Fox's polycor::hetcor function
}
\examples{
umxHetCor(mtcars[,c("mpg", "am")])
umxHetCor(mtcars[,c("mpg", "am")], treatAllAsFactor = FALSE, verbose = TRUE)
}
\references{
-
}
\seealso{
- \code{\link[polycor]{hetcor}}

Other Miscellaneous Data Functions: \code{\link{umxPadAndPruneForDefVars}};
  \code{\link{umx_as_numeric}};
  \code{\link{umx_cont_2_ordinal}};
  \code{\link{umx_cov2raw}}; \code{\link{umx_lower2full}};
  \code{\link{umx_make_bin_cont_pair_data}};
  \code{\link{umx_merge_CIs}};
  \code{\link{umx_read_lower}};
  \code{\link{umx_residualize}}; \code{\link{umx_round}};
  \code{\link{umx_scale_wide_twin_data}};
  \code{\link{umx_scale}}; \code{\link{umx_swap_a_block}};
  \code{\link{umx}}, \code{\link{umx-package}}
}

