% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_paste_names}
\alias{umx_paste_names}
\title{umx_paste_names}
\usage{
umx_paste_names(varNames, textConstant = "", suffixes)
}
\arguments{
\item{varNames}{a list of base names, e.g c("bmi", "IQ")}

\item{textConstant}{The suffix added to all names, e.g. "_T" (default is "")}

\item{suffixes}{a list of terminal suffixes differentiating the var names (e.g c("1", "2"))}
}
\value{
- vector of suffixed var names, i.e., c("a_T1", "b_T1", "a_T2", "b_T2")
}
\description{
Helper to add suffixes to names: useful for expanding twin vars like "bmi" into c("bmi_T1", "bmi_T2")
Use textConstant to turning add a constant"E_T1", by adding "_T" and 1.
}
\examples{
umx_paste_names("bmi", "_T", 1:2)
umx_paste_names("bmi", suffixes = c("_T1", "_T2"))
varNames = umx_paste_names(c("N", "E", "O", "A", "C"), "_T", 1:2)
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
Other Miscellaneous Functions: \code{\link{umxEval}};
  \code{\link{umxJiggle}}; \code{\link{umx_APA_pval}};
  \code{\link{umx_add_variances}}; \code{\link{umx_apply}};
  \code{\link{umx_check_model}};
  \code{\link{umx_check_multi_core}};
  \code{\link{umx_checkpoint}},
  \code{\link{umx_set_checkpoint}};
  \code{\link{umx_check}};
  \code{\link{umx_default_option}};
  \code{\link{umx_explode}};
  \code{\link{umx_get_CI_as_APA_string}};
  \code{\link{umx_get_bracket_addresses}};
  \code{\link{umx_get_checkpoint}};
  \code{\link{umx_get_cores}};
  \code{\link{umx_get_optimizer}};
  \code{\link{umx_has_CIs}};
  \code{\link{umx_has_been_run}};
  \code{\link{umx_has_means}};
  \code{\link{umx_has_square_brackets}};
  \code{\link{umx_is_MxMatrix}};
  \code{\link{umx_is_MxModel}}; \code{\link{umx_is_RAM}};
  \code{\link{umx_is_cov}};
  \code{\link{umx_is_endogenous}};
  \code{\link{umx_is_exogenous}};
  \code{\link{umx_is_ordered}}; \code{\link{umx_msg}};
  \code{\link{umx_names}}; \code{\link{umx_object_as_str}};
  \code{\link{umx_print}}; \code{\link{umx_rename}};
  \code{\link{umx_reorder}}; \code{\link{umx_rot}};
  \code{\link{umx_set_cores}};
  \code{\link{umx_set_optimizer}};
  \code{\link{umx_string_to_algebra}};
  \code{\link{umx_trim}}; \code{\link{umx}},
  \code{\link{umx-package}}
}

