% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/build_run_modify.r
\name{umxPath}
\alias{umxPath}
\title{umxPath: Flexible specification of sem paths}
\usage{
umxPath(from = NULL, to = NULL, with = NULL, var = NULL, cov = NULL,
  unique.bivariate = NULL, formative = NULL, Cholesky = NULL,
  means = NULL, v1m0 = NULL, v.m. = NULL, fixedAt = NULL,
  freeAt = NULL, firstAt = NULL, connect = c("single", "all.pairs",
  "all.bivariate", "unique.pairs", "unique.bivariate"), arrows = 1,
  free = TRUE, values = NA, labels = NA, lbound = NA, ubound = NA)
}
\arguments{
\item{from}{either a source variable e.g "A" or c("A","B"), OR a sem-style path description, e.g. "A-> B" or "C <> B"}

\item{to}{one or more target variables for one-headed paths, e.g "A" or c("A","B")}

\item{with}{same as "to = vars, arrows = 2". nb: from, to= and var=  must be left empty (their default)}

\item{var}{equivalent to setting "from = vars, arrows = 2". nb: from, to, and with must be left empty (their default)}

\item{cov}{equivalent to setting "from = X, to = Y, arrows = 2". nb: from, to, and with must be left empty (their default)}

\item{unique.bivariate}{equivalent to setting "connect = "unique.bivariate", arrows = 2". nb: from, to, and with must be left empty (their default)}

\item{formative}{Paired with to, this will build a formative variable, from the formatives, allowing these to
covary, and to the latent "to" variable, fixing its variance to zero.}

\item{Cholesky}{Treat the \strong{from} vars as latent and \strong{to} as measured, and connect up as in an ACE model.}

\item{means}{equivalent to "from = 'one', to = x. nb: from, to, with and var must be left empty (their default).}

\item{v1m0}{variance of 1 and mean of zero in one call.}

\item{v.m.}{variance and mean added, both free.}

\item{fixedAt}{Equivalent to setting "free = FALSE, values = x" nb: free and values must be left empty (their default)}

\item{freeAt}{Equivalent to setting "free = TRUE, values = x" nb: free and values must be left empty (their default)}

\item{firstAt}{first value is fixed at this (values passed to free are ignored: warning if not a single TRUE)}

\item{connect}{as in mxPath - nb: Only used when using from and to}

\item{arrows}{as in mxPath - nb: Only used when using from and to}

\item{free}{whether the value is free to be optimised}

\item{values}{default value list}

\item{labels}{labels for each path}

\item{lbound}{lower bounds for each path value}

\item{ubound}{upper bounds for each path value}
}
\value{
- 1 or more \code{\link{mxPath}}s
}
\description{
The goal of this function is to enable quck-to-write, quick-to-read, flexible path descriptions for RAM models in OpenMx.

It introduces 11 new words to our vocabulary for describing paths: \strong{with}, \strong{var}, \strong{cov}, \strong{unique.bivariate}, \strong{Cholesky}, \strong{means}, \strong{v1m0}, \strong{v.m.}, \strong{fixedAt}, \strong{freeAt}, \strong{firstAt}.

The new preposition \dQuote{with} means you no-longer need set arrows = 2 on covariances. Instead, you can say:

   \code{umxPath(A, with = B)} instead of \code{mxPath(from = A, to = B, arrows = 2)}.

Specify a variance for A with

\code{umxPath(var = A)}.

This is equivalent to \code{mxPath(from = A, to = A, arrows = 2)}.

Of course you can use vectors anywhere:

\code{umxPath(var = c('N','E', 'O'))}

To specify a mean, you just say

\code{umxPath(mean = A)}, which is equivalent to \code{mxPath(from = "one", to = A)}.

To fix a path at a value, instead of to \code{mxPath(from = A, to = A, arrows = 2, free = FALSE, values = 1)} you can say:

\code{umxPath(var = A, fixedAt = 1)} .

The common task of creating a variable with variance fixed at 1 and mean at 0 is done thus:

\code{umxPath(v1m0 = A)}

For convenience, you may request estimated variance and means with \code{umxPath(v.m. = A)}


umxPath exposes \dQuote{unique.bivariate} so you don't have to remember
how to fill in connect = in mxPath (you can still use connect if you wish).

So, to create paths A<->B, B<->C, and A<->C, you would say:

\code{umxPath(unique.bivariate = c('A',"B","C"))}


Setting up a latent trait, you can fix the loading of the first path with

\code{mxPath(A, to = c(B,C,D), fixFirst = TRUE)}

This is equivalent to \code{mxPath(from = A, to = c(B,C,D), free = c(F, T, T), values = c(1, .5, .4))}.

Finally, there are two promised features, not implemented in this release.

\emph{Cholesky} form paths (see \code{\link{umxACE}}) will be created by:

\code{umxPath(Cholesky = c("A1", "A2"), to c("var1", "var2"))}

I will also implement John Fox "sem"-package style notation,
i.e., "A -> B; X <-> B; " (see examples below.)
}
\details{
This function returns a standard mxPath, but gives new options for specifying the path. In addition to the normal
\dQuote{from} and \dQuote{to}, it adds specialised parameters for variances (var), two headed paths (with) and means (mean).
There are also new terms to describe fixing values: \dQuote{fixedAt} and \dQuote{fixFirst}.

Finally, (in future) it will allow sem-style \dQuote{A->B} string specification.
}
\examples{
require(OpenMx)
# Some examples of paths with umxPath
umxPath("A", to = "B") # One-headed path from A to B
umxPath("A", to = "B", fixedAt = 1) # same, with value fixed @1
umxPath("A", to = LETTERS[2:4], firstAt = 1) # Fix only the first path, others free
umxPath(var = "A") # Give a variance to A
umxPath(var = "A", fixedAt = 1) # Give a variance, fixed at 1
umxPath(var = LETTERS[1:5], fixedAt = 1)
umxPath(means = c("A","B")) # Create a means model for A: from = "one", to = "A"
umxPath(v1m0 = "A") # Give "A" variance and a mean, fixed at 1 and 0 respectively
umxPath(v.m. = "A") # Give "A" variance and a mean, leaving both free.
umxPath("A", with = "B") # using with: same as "to = B, arrows = 2"
umxPath("A", with = "B", fixedAt = .5)
umxPath("A", with = "B", firstAt = 1)
umxPath("A", with = c("B","C"), fixedAt = 1)
umxPath(cov = c("A", "B"))  # Covariance A <-> B
umxPath(unique.bivariate = letters[1:4]) # bivariate paths a<->b, a<->c, a<->d, b<->c etc.
# A worked example
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
myData = mxData(cov(demoOneFactor), type = "cov", numObs = 500)
m1 <- umxRAM("One Factor", data = myData,
	umxPath(latents, to = manifests),
	umxPath(var = manifests),
	umxPath(var = latents, fixedAt = 1.0)
)
umxSummary(m1, show = "std")

# The following NOT YET implemented!!
# umxPath("A <-> B") # same path as above using a string
# umxPath("A -> B") # one-headed arrow with string syntax
# umxPath("A <> B; A <-- B") # This is ok too
# umxPath("A -> B; B>C; C --> D") # two paths. white space and hyphens not needed
# # manifests is a reserved word, as is latents.
# # It allows the string syntax to use the manifestVars variable
# umxPath("A -> manifests")
}
\references{
- \url{http://tbates.github.io}
}
\seealso{
- \code{\link{mxPath}}, \code{\link{umxLabel}}, \code{\link{umxLabel}}

Other Model Building Functions: \code{\link{umxCP}};
  \code{\link{umxDiagnose}}; \code{\link{umxGxE}};
  \code{\link{umxIP}}; \code{\link{umxLabel}};
  \code{\link{umxLatent}}; \code{\link{umxRAM}};
  \code{\link{umxReRun}}; \code{\link{umxRun}};
  \code{\link{umxThresholdMatrix}};
  \code{\link{umxValues}};
  \code{\link{umx_fix_first_loadings}};
  \code{\link{umx_fix_latents}}; \code{\link{umx}},
  \code{\link{umx-package}}
}

