% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxSummaryCP}
\alias{umxSummary.MxModel.CP}
\alias{umxSummaryCP}
\title{umxSummaryCP}
\usage{
umxSummaryCP(model, digits = 2, dotFilename = "name", returnStd = FALSE,
  extended = FALSE, showRg = TRUE, comparison = NULL, showStd = TRUE,
  CIs = FALSE, ...)
}
\arguments{
\item{model}{A fitted \code{\link{umxCP}} model to summarize}

\item{digits}{rounding (default = 2)}

\item{dotFilename}{The name of the dot file to write. Defaults to name of the model. NA = no plot}

\item{returnStd}{Whether to return the standardized form of the model (default = FALSE)}

\item{extended}{how much to report (FALSE)}

\item{showRg}{Whether to show the genetic correlations (FALSE) (Not implemented!)}

\item{comparison}{Whether to run mxCompare on a comparison model (NULL)}

\item{showStd}{Whether to show the standardized model (TRUE) (Not implemented!)}

\item{CIs}{Confidence intervals (F)}

\item{...}{Optional additional parameters}
}
\value{
- optional \code{\link{mxModel}}
}
\description{
Summarise a Commmon Pathway model, as returned by \code{\link{umxCP}}
}
\examples{
require(OpenMx)
data(twinData)
labList = c("MZFF", "MZMM", "DZFF", "DZMM", "DZOS")
twinData$ZYG = factor(twinData$zyg, levels = 1:5, labels = labList)
selDVs = c("ht", "wt") # will be expanded into "ht1", "wt1", "ht2", "wt2"
mzData <- subset(twinData, ZYG == "MZFF")
dzData <- subset(twinData, ZYG == "DZFF")
m1 = umxCP(selDVs = selDVs, dzData = dzData, mzData = mzData, suffix = "")
m1 = mxRun(m1)
umxSummaryCP(m1, dotFilename = NA) # suppress plot creation with dotFilename
umxSummary(m1, dotFilename = NA) # generic summary is the same
stdFit = umxSummaryCP(m1, digits = 2, dotFilename = NA, returnStd = FALSE,
		extended = FALSE, showRg = TRUE, showStd = TRUE, CIs = TRUE);
\dontrun{
examples which will create graphical output
umxSummaryCP(fit);
umxSummaryCP(fit, dotFilename = "Figure 3", showStd = TRUE)
}
}
\references{
- \url{http://www.github.com/tbates/umx}, \url{http://tbates.github.io}
}
\seealso{
- \code{\link{umxCP}()}, \code{\link{plot}()}, \code{\link{umxSummary}()} work for IP, CP, GxE, SAT, and ACE models.

Other Reporting Functions: \code{\link{umxStandardizeACE}};
  \code{\link{umx_APA_CI}}; \code{\link{umx_APA_pval}};
  \code{\link{umx_aggregate}}; \code{\link{umx_print}};
  \code{\link{umx_show}}; \code{\link{umx_time}};
  \code{\link{umx}}, \code{\link{umx-package}}
}

