% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_cont_2_ordinal}
\alias{umx_cont_2_ordinal}
\title{umx_cont_2_ordinal}
\usage{
umx_cont_2_ordinal(var, nlevels = 10, type = c("mxFactor", "ordered",
  "unordered"), verbose = FALSE)
}
\arguments{
\item{var}{a variable to recode as ordinal}

\item{nlevels}{how many bins or levels (at most) to use (default = 10 i,e deciles)}

\item{type}{what to return (Default is "mxFactor") options include
"ordered" and "unordered")}

\item{verbose}{report the min, max, and decile cuts used (default = FALSE)}
}
\value{
- recoded variable as an \code{\link{mxFactor}}
}
\description{
Recode a variable into n-quantiles (default = deciles (10 levels)).
It returns an \code{\link{mxFactor}}, with the levels labeled with the max value
in each quantile (i.e., open on the left-side).
}
\details{
\strong{Note}: Redundant bins are merged. i.e., if the same score identifies
all deciles up to the fourth, then these will be merged into one level.
}
\examples{
x = umx_cont_2_ordinal(rnorm(10000), verbose = TRUE)
x = umx_cont_2_ordinal(rep(0:10, 10), verbose = TRUE)
levels(x)
str(umx_cont_2_ordinal(rnorm(10000), nlevels = 4, verbose = TRUE))
}
\references{
- \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
\seealso{
Other Data Functions: \code{\link{umxCovData}},
  \code{\link{umxFactor}}, \code{\link{umxHetCor}},
  \code{\link{umxPadAndPruneForDefVars}},
  \code{\link{umx_as_numeric}}, \code{\link{umx_cov2raw}},
  \code{\link{umx_fake_data}},
  \code{\link{umx_lower2full}},
  \code{\link{umx_make_bin_cont_pair_data}},
  \code{\link{umx_merge_CIs}},
  \code{\link{umx_read_lower}}, \code{\link{umx_reorder}},
  \code{\link{umx_residualize}}, \code{\link{umx_round}},
  \code{\link{umx_scale_wide_twin_data}},
  \code{\link{umx_scale}}, \code{\link{umx_swap_a_block}},
  \code{\link{umx}}
}

