% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.r
\name{umxACEcov}
\alias{umxACEcov}
\title{umxACEcov}
\usage{
umxACEcov(name = "ACEcov", selDVs, selCovs, dzData, mzData, suffix = NULL,
  dzAr = 0.5, dzCr = 1, addStd = TRUE, addCI = TRUE, boundDiag = NULL,
  equateMeans = TRUE, bVector = FALSE, hint = c("none", "left_censored"),
  autoRun = getOption("umx_auto_run"))
}
\arguments{
\item{name}{The name of the model (defaults to"ACE")}

\item{selDVs}{The variables to include from the data (do not include suffixes)}

\item{selCovs}{The covariates to include from the data (do not include suffixes)}

\item{dzData}{The DZ dataframe}

\item{mzData}{The MZ dataframe}

\item{suffix}{suffix for twin 1 and twin 2, often "_T" Used to expand selDVs into
full column names, i,e "dep" -->  c("dep_T1", "dep_T2")}

\item{dzAr}{The DZ genetic correlation (defaults to .5, vary to examine assortative mating)}

\item{dzCr}{The DZ "C" correlation (defaults to 1: set to .25 to make an ADE model)}

\item{addStd}{Whether to add the algebras to compute a std model (defaults to TRUE)}

\item{addCI}{Whether to add intervals to compute CIs (defaults to TRUE)}

\item{boundDiag}{= Whether to bound the diagonal of the a, c, and e matrices}

\item{equateMeans}{Whether to equate the means across twins (defaults to TRUE)}

\item{bVector}{Whether to compute row-wise likelihoods (defaults to FALSE)}

\item{hint}{An analysis hint. Options include "none", (default) "left_censored". Default does nothing.}

\item{autoRun}{Whether to run the model and return it, or just return it}
}
\value{
- \code{\link{mxModel}} of subclass mxModel.ACEcov
}
\description{
Make a 2-group ACE Cholesky Twin model with covariates modeled (see Details below)
}
\details{
umxACEcov supplements the \code{\link{umxACE}} Cholesky model with covariates.
}
\examples{
# Height, weight, and BMI data from Australian twins. 
# The total sample has been subdivided into a young cohort, aged 18-30 years,
# and an older cohort aged 31 and above.
# Cohort 1 Zygosity is coded as follows: 
# 1 == MZ females 2 == MZ males 3 == DZ females 4 == DZ males 5 == DZ opposite sex pairs
# tip: ?twinData to learn more about this data set
require(umx)
data(twinData)
tmpTwin <- twinData
# add age 1 and age 2 columns
tmpTwin$age1 = tmpTwin$age2 = tmpTwin$age
# Pick the variables. We will use base names (i.e., "bmi") and set suffix.
selDVs  = c("bmi")
selCovs = c("age")
selVars = umx_paste_names(c(selDVs, selCovs), textConstant = "", suffixes= 1:2)
# just top 200 so example runs in a couple of secs
mzData = subset(tmpTwin, zyg == 1, selVars)[1:200, ]
dzData = subset(tmpTwin, zyg == 3, selVars)[1:200, ]
# TODO update for new dataset variable zygosity
# mzData = subset(tmpTwin, zygosity == "MZFF", selVars)[1:200, ]
# dzData = subset(tmpTwin, zygosity == "DZFF", selVars)[1:200, ]
m1 = umxACEcov(selDVs = selDVs, selCovs = selCovs, dzData = dzData, mzData = mzData, 
	 suffix = "", autoRun = TRUE)
umxSummary(m1)
\dontrun{
plot(m1)
}
}
\references{
- Neale, M. C., & Martin, N. G. (1989). The effects of age, sex, 
and genotype on self-report drunkenness following a challenge dose of alcohol. 
Behavior Genetics, 19(1), 63-78. doi:10.1007/BF01065884
}
\seealso{
Other Twin Modeling Functions: \code{\link{umxACESexLim}},
  \code{\link{umxACE}}, \code{\link{umxCF_SexLim}},
  \code{\link{umxCP}}, \code{\link{umxGxE_window}},
  \code{\link{umxGxE}}, \code{\link{umxIP}},
  \code{\link{umxPlotCP}}, \code{\link{umxPlotGxE}},
  \code{\link{umxSummaryACEcov}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryCP}},
  \code{\link{umxSummaryGxE}}, \code{\link{umxSummaryIP}},
  \code{\link{umx_make_TwinData}}, \code{\link{umx}}
}

