% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_scale}
\alias{umx_scale}
\title{umx_scale}
\usage{
umx_scale(df, varsToScale = NULL, coerce = FALSE)
}
\arguments{
\item{df}{a dataframe to scale}

\item{varsToScale}{(leave blank for all)}

\item{coerce}{Whether to coerce non-numerics to numeric (Defaults to FALSE)}
}
\value{
- new dataframe with scaled variables
}
\description{
Scale data columns, skipping ordinal
}
\examples{
data(twinData) 
df = umx_scale(twinData, varsToScale = NULL)
plot(wt1 ~ wt2, data = df)
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
Other Data Functions: \code{\link{umxCovData}},
  \code{\link{umxFactor}}, \code{\link{umxHetCor}},
  \code{\link{umxPadAndPruneForDefVars}},
  \code{\link{umx_as_numeric}},
  \code{\link{umx_cont_2_quantiles}},
  \code{\link{umx_cov2raw}}, \code{\link{umx_lower2full}},
  \code{\link{umx_make_MR_data}},
  \code{\link{umx_make_TwinData}},
  \code{\link{umx_make_bin_cont_pair_data}},
  \code{\link{umx_make_fake_data}},
  \code{\link{umx_merge_CIs}},
  \code{\link{umx_read_lower}}, \code{\link{umx_reorder}},
  \code{\link{umx_residualize}}, \code{\link{umx_round}},
  \code{\link{umx_scale_wide_twin_data}},
  \code{\link{umx_swap_a_block}}, \code{\link{umx}}
}
