% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_var}
\alias{umx_var}
\title{Get variances from a df that might contain some non-numeric columns}
\usage{
umx_var(df, ordVar = 1, format = c("full", "diag", "lower"),
  use = c("complete.obs", "pairwise.complete.obs", "everything", "all.obs",
  "na.or.complete"))
}
\arguments{
\item{df}{a dataframe of raw data from which to get variances.}

\item{ordVar}{The value to return at any ordinal columns (defaults to 1).}

\item{format}{to return: options are c("full", "diag", "lower"). Defaults to full, but this is not implemented yet.}

\item{use}{passed to \code{\link{cov}} - defaults to "complete.obs" (see param default for other options).}
}
\value{
- \code{\link{mxModel}}
}
\description{
Pass in any dataframe and get variances despite some non-numeric columns.
Cells involving these non-numeric columns are set to ordVar (default = 1).
}
\examples{
tmp = mtcars[,1:4]
tmp$cyl = ordered(mtcars$cyl) # ordered factor
tmp$hp  = ordered(mtcars$hp)  # binary factor
umx_var(tmp, format= "diag", ordVar = 1, use = "pair")
tmp2 = tmp[, c(1,3)]
umx_var(tmp2, format= "diag")
# todo: umx_var(tmp2, format = "full")
}
\references{
- \url{http://tbates.github.io}
}
\seealso{
Other Building Functions: \code{\link{umx_check_names}}
}
