% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.r
\name{umxLatent}
\alias{umxLatent}
\title{umxLatent: Helper to ease making formative and reflective latent variables}
\usage{
umxLatent(latent = NULL, formedBy = NULL, forms = NULL, data = NULL,
  type = NULL, name = NULL, labelSuffix = "", verbose = TRUE)
}
\arguments{
\item{latent}{the name of the latent variable (string)}

\item{formedBy}{the list of variables forming this latent}

\item{forms}{the list of variables which this latent forms (leave blank for formedBy)}

\item{data}{the dataframe being used in this model}

\item{type}{= \"exogenous|endogenous\"}

\item{name}{A name for the path NULL}

\item{labelSuffix}{a suffix string to append to each label}

\item{verbose}{Default is TRUE as this function does quite a lot}
}
\value{
- path list
}
\description{
Helper to ease the creation of latent variables including formative and reflective variables (see below)
For formative variables, the manifests define (form) the latent.
This function takes care of intercorrelating manifests for formatives, and fixing variances correctly
}
\details{
The following figures show how a reflective and a formative variable look as path diagrams:
\figure{reflective.png}
formative\figure{formative.png}
}
\examples{
\dontrun{
library(umx)
data(demoOneFactor)
latents = c("G")
manifests = names(demoOneFactor) # x1-5
theData = cov(demoOneFactor)
m1 = mxModel("reflective", type = "RAM",
manifestVars = manifests,
latentVars   = latents,
# Factor loadings
umxLatent("G", forms = manifests, type = "exogenous", data = theData),
mxData(theData, type = "cov", numObs = nrow(demoOneFactor))
)
m1 = umxRun(m1, setValues = TRUE, setLabels = TRUE); umxSummary(m1, show="std")
plot(m1)

m2 = mxModel("formative", type = "RAM",
manifestVars = manifests,
latentVars   = latents,
# Factor loadings
umxLatent("G", formedBy = manifests, data = theData),
mxData(theData, type = "cov", numObs = nrow(demoOneFactor))
)
m2 = umxRun(m2, setValues = TRUE, setLabels = TRUE);
umxSummary(m2, show = "std")
plot(m2)
}
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
Other Core Modelling Functions: \code{\link{plot.MxModel}},
  \code{\link{umxDiagnose}}, \code{\link{umxMatrix}},
  \code{\link{umxPath}}, \code{\link{umxRAM}},
  \code{\link{umxReduceACE}}, \code{\link{umxReduceGxE}},
  \code{\link{umxRun}}, \code{\link{umxSuperModel}},
  \code{\link{umx}}
}
