% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umxPadAndPruneForDefVars}
\alias{umxPadAndPruneForDefVars}
\title{umxPadAndPruneForDefVars}
\usage{
umxPadAndPruneForDefVars(df, varNames, defNames, suffixes, highDefValue = 99,
  rm = c("drop_missing_def", "pad_with_mean"))
}
\arguments{
\item{df}{the dataframe to process}

\item{varNames}{list of names of the variables being analysed}

\item{defNames}{list of covariates}

\item{suffixes}{suffixes that map names on columns in df (i.e., c("T1", "T2"))}

\item{highDefValue}{What to replace missing definition variables (covariates) with. Default = 99}

\item{rm}{= how to handle missing values in the varNames. Default is "drop_missing_def", "pad_with_mean")}
}
\value{
- dataframes
}
\description{
Replaces NAs in definition slots with the mean for that variable ONLY where all data are missing for that twin
}
\examples{
\dontrun{
df = umxPadAndPruneForDefVars(df, "E", "age", c("_T1", "_T2"))
}
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
Other Data Functions: \code{\link{umxCovData}},
  \code{\link{umxFactor}}, \code{\link{umxHetCor}},
  \code{\link{umx_as_numeric}},
  \code{\link{umx_cont_2_quantiles}},
  \code{\link{umx_cov2raw}}, \code{\link{umx_long2wide}},
  \code{\link{umx_lower2full}},
  \code{\link{umx_make_MR_data}},
  \code{\link{umx_make_TwinData}},
  \code{\link{umx_make_bin_cont_pair_data}},
  \code{\link{umx_make_fake_data}},
  \code{\link{umx_merge_CIs}},
  \code{\link{umx_read_lower}}, \code{\link{umx_reorder}},
  \code{\link{umx_residualize}}, \code{\link{umx_round}},
  \code{\link{umx_scale_wide_twin_data}},
  \code{\link{umx_scale}}, \code{\link{umx_swap_a_block}},
  \code{\link{umx_wide2long}}, \code{\link{umx}}
}
