% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxPlotACE}
\alias{umxPlotACE}
\alias{plot.MxModelACE}
\title{umxPlotACE}
\usage{
umxPlotACE(x = NA, file = "name", digits = 2, means = FALSE,
  std = TRUE, ...)
}
\arguments{
\item{x}{\code{\link{mxModel}} to plot (created by umxACE in order to inherit the MxModelACE class)}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{digits}{How many decimals to include in path loadings (default is 2)}

\item{means}{Whether to show means paths (default is FALSE)}

\item{std}{Whether to standardize the model (default is TRUE)}

\item{...}{Additional (optional) parameters}
}
\value{
- optionally return the dot code
}
\description{
Make a graphical display of an ACE model
}
\examples{
require(umx)
data(twinData)
selDVs = "bmi"
mzData <- subset(twinData, zygosity == "MZFF")
dzData <- subset(twinData, zygosity == "DZFF")
m1 = umxACE(selDVs = selDVs, dzData = dzData, mzData = mzData, sep = "")
plot(m1, std = FALSE) # don't standardize
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
- \code{\link{plot}()}, \code{\link{umxSummary}()} work for IP, CP, GxE, SAT, and ACE models.

- \code{\link{umxACE}}

Other Plotting functions: \code{\link{plot.MxModel}},
  \code{\link{umxPlotACEcov}}, \code{\link{umxPlotACEv}},
  \code{\link{umxPlotCPnew}}, \code{\link{umxPlotCP}},
  \code{\link{umxPlotGxEbiv}}, \code{\link{umxPlotGxE}},
  \code{\link{umxPlotIP}}, \code{\link{umxPlotSimplex}},
  \code{\link{umx}}
}
