% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_lower2full}
\alias{umx_lower2full}
\title{Convert lower-only matrix data to full (or enforce symmetry on a full matrix)}
\usage{
umx_lower2full(lower.data, diag = NULL, byrow = TRUE,
  dimnames = NULL)
}
\arguments{
\item{lower.data}{An \code{\link{mxMatrix}}}

\item{diag}{A boolean specifying whether the lower.data includes the diagonal}

\item{byrow}{Whether the matrix is to be filled by row or by column (default = TRUE)}

\item{dimnames}{Optional dimnames for the matrix (defaults to NULL)}
}
\value{
- \code{\link{mxMatrix}}
}
\description{
Takes a vector of the lower-triangle of cells in a matrix as you might read-in
from a journal article), OR a matrix (for instance from a "lower" \code{\link{mxMatrix}}, 
and returns a full matrix, copying the lower triangle into the upper.
}
\details{
*note*: Can also take lower data presented in the form of a data.frame. Note also, if 
presented with a full matrix, the function will return a matrix with  symmetry enforced. Can be
handy when you have a "nearly-symmetrical" matrix (with differences in the tenth decimal place).
}
\examples{

# 1. Test with a vector in byrow = TRUE order) 
tmp = c(
	1.0000, 
	0.6247, 1.0000,
	0.3269, 0.3669, 1.0000,
	0.4216, 0.3275, 0.6404, 1.0000,
	0.2137, 0.2742, 0.1124, 0.0839, 1.0000,
	0.4105, 0.4043, 0.2903, 0.2598, 0.1839, 1.0000,
	0.3240, 0.4047, 0.3054, 0.2786, 0.0489, 0.2220, 1.0000,
	0.2930, 0.2407, 0.4105, 0.3607, 0.0186, 0.1861, 0.2707,  1.0000,
	0.2995, 0.2863, 0.5191, 0.5007, 0.0782, 0.3355, 0.2302,  0.2950, 1.0000,
	0.0760, 0.0702, 0.2784, 0.1988, 0.1147, 0.1021, 0.0931, -0.0438, 0.2087, 1.000
)
x = umx_lower2full(tmp, diag = TRUE)
# check
isSymmetric(x)

# 2. Test with matrix input
tmpn = c("ROccAsp", "REdAsp", "FOccAsp", "FEdAsp", "RParAsp", 
         "RIQ", "RSES", "FSES", "FIQ", "FParAsp")
tmp = matrix(nrow = 10, ncol = 10, byrow = TRUE, dimnames = list(tmpn,tmpn), data = 
	c(1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000,  0.0000, 0.0000, 0,
	0.6247, 1.0000, 0.0000, 0.0000, 0.0000, 0.0000, 0.0000,  0.0000, 0.0000, 0,
	0.3269, 0.3669, 1.0000, 0.0000, 0.0000, 0.0000, 0.0000,  0.0000, 0.0000, 0,
	0.4216, 0.3275, 0.6404, 1.0000, 0.0000, 0.0000, 0.0000,  0.0000, 0.0000, 0,
	0.2137, 0.2742, 0.1124, 0.0839, 1.0000, 0.0000, 0.0000,  0.0000, 0.0000, 0,
	0.4105, 0.4043, 0.2903, 0.2598, 0.1839, 1.0000, 0.0000,  0.0000, 0.0000, 0,
	0.3240, 0.4047, 0.3054, 0.2786, 0.0489, 0.2220, 1.0000,  0.0000, 0.0000, 0,
	0.2930, 0.2407, 0.4105, 0.3607, 0.0186, 0.1861, 0.2707,  1.0000, 0.0000, 0,
	0.2995, 0.2863, 0.5191, 0.5007, 0.0782, 0.3355, 0.2302,  0.2950, 1.0000, 0,
	0.0760, 0.0702, 0.2784, 0.1988, 0.1147, 0.1021, 0.0931, -0.0438, 0.2087, 1)
)
x = umx_lower2full(tmp, diag= TRUE)
isSymmetric(x)

# 3. Test with lower-vector, no diagonal.
tmp = c(
	0.6247,
	0.3269, 0.3669,
	0.4216, 0.3275, 0.6404,
	0.2137, 0.2742, 0.1124, 0.0839,
	0.4105, 0.4043, 0.2903, 0.2598, 0.1839,
	0.3240, 0.4047, 0.3054, 0.2786, 0.0489, 0.2220,
	0.2930, 0.2407, 0.4105, 0.3607, 0.0186, 0.1861, 0.2707, 
	0.2995, 0.2863, 0.5191, 0.5007, 0.0782, 0.3355, 0.2302,  0.2950,
	0.0760, 0.0702, 0.2784, 0.1988, 0.1147, 0.1021, 0.0931, -0.0438, 0.2087
)
umx_lower2full(tmp, diag = FALSE)
	
	# An example with byrow = FALSE
	
	ldiag = c(
	1, -.17, -.22, -.19, -.12, .81, -.02, -.26, -.2, -.15,
	1, .11, .2, .21, -.01, .7, .1, .7, .1, .17, .22,
	1, .52, .68, -.12, .09, .49, .27, .46,
	1, .5, -.06, .17, .26, .80, .31,
	1, -.1, .19, .36, .23, .42,
	1, .02, -19, -.06, -.06,
	1, .1, .18, .27,
	1, .51, .7,
	1, .55, 
	1)
umx_lower2full(tmp, byrow = FALSE, diag = TRUE)

}
\references{
- \url{https://www.github.com/tbates/umx}
}
\seealso{
Other Data Functions: \code{\link{umxCovData}},
  \code{\link{umxHetCor}},
  \code{\link{umxPadAndPruneForDefVars}},
  \code{\link{umx_as_numeric}}, \code{\link{umx_cov2raw}},
  \code{\link{umx_make_MR_data}},
  \code{\link{umx_make_TwinData}},
  \code{\link{umx_make_bin_cont_pair_data}},
  \code{\link{umx_make_fake_data}},
  \code{\link{umx_polychoric}},
  \code{\link{umx_polypairwise}},
  \code{\link{umx_polytriowise}},
  \code{\link{umx_read_lower}}, \code{\link{umx_rename}},
  \code{\link{umx_reorder}}, \code{\link{umx_stack}},
  \code{\link{umx_swap_a_block}}, \code{\link{umx}}
}
\concept{Data Functions}
