% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_is_exogenous}
\alias{umx_is_exogenous}
\title{umx_is_exogenous}
\usage{
umx_is_exogenous(model, manifests_only = TRUE)
}
\arguments{
\item{model}{an \code{\link[=mxModel]{mxModel()}} from which to get exogenous variables}

\item{manifests_only}{Whether to check only manifests (default = TRUE)}
}
\value{
\itemize{
\item list of exogenous variables
}
}
\description{
Return a list of all the exogenous variables (variables with no incoming single-arrow path) in a model.
}
\examples{
require(umx)
data(demoOneFactor)
m1 = umxRAM("One Factor", data = demoOneFactor, type = "cov",
	umxPath("g", to = names(demoOneFactor)),
	umxPath(var = "g", fixedAt = 1),
	umxPath(var = names(demoOneFactor))
)
umx_is_exogenous(m1, manifests_only = TRUE)
umx_is_exogenous(m1, manifests_only = FALSE)
}
\references{
\itemize{
\item \url{https://tbates.github.io},  \url{https://github.com/tbates/umx}
}
}
\seealso{
Other Check or test: \code{\link{umx_check_names}()},
  \code{\link{umx_is_class}()},
  \code{\link{umx_is_endogenous}()},
  \code{\link{umx_is_numeric}()}, \code{\link{umx}}
}
\concept{Check or test}
