% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{iqdat}
\alias{iqdat}
\title{Twin data: IQ measured longitudinally}
\format{A data frame with 562 rows and 9 variables}
\usage{
data(iqdat)
}
\description{
Measures of IQ across four ages in 261 pairs of identical twins and 301 pairs of fraternal (DZ) twins. (see details)
}
\details{
\itemize{
  \item zygosity Zygosity (MZ or DZ)
  \item IQ_age1_T1 T1 IQ measured at age 1
  \item IQ_age2_T1 T1 IQ measured at age 2
  \item IQ_age3_T1 T1 IQ measured at age 3
  \item IQ_age4_T1 T1 IQ measured at age 4
  \item IQ_age1_T2 T2 IQ measured at age 1
  \item IQ_age2_T2 T2 IQ measured at age 2
  \item IQ_age3_T2 T2 IQ measured at age 3
  \item IQ_age4_T2 T2 IQ measured at age 4
}
}
\examples{
data(iqdat)
str(iqdat)
par(mfrow = c(1, 3))  # 1 rows and 3 columns
plot(IQ_age4_T1 ~ IQ_age4_T2, ylim = c(50, 150), data = subset(iqdat, zygosity == "MZ"))
plot(IQ_age4_T1 ~ IQ_age4_T2, ylim = c(50, 150), data = subset(iqdat, zygosity == "DZ"))
plot(IQ_age1_T1 ~ IQ_age4_T2, data = subset(iqdat, zygosity == "MZ"))
par(mfrow = c(1, 1))  # back to as it was
}
\references{
TODO
}
\seealso{
Other datasets: \code{\link{Fischbein_wt}},
  \code{\link{GFF}}, \code{\link{umx}},
  \code{\link{us_skinfold_data}}
}
\concept{datasets}
\keyword{datasets}
