% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{residuals.MxModel}
\alias{residuals.MxModel}
\title{Get residuals from an MxModel}
\usage{
\method{residuals}{MxModel}(object, digits = 2, suppress = NULL, reorder = NULL, ...)
}
\arguments{
\item{object}{An fitted \code{\link[=mxModel]{mxModel()}} from which to get residuals}

\item{digits}{round to how many digits (default = 2)}

\item{suppress}{smallest deviation to print out (default = NULL = show all)}

\item{reorder}{optionally reorder the variables in the residuals matrix to show patterns}

\item{...}{Optional parameters}
}
\value{
\itemize{
\item matrix of residuals
}
}
\description{
Return the \code{\link[=residuals]{residuals()}} from an OpenMx RAM model. You can format these (with digits), and suppress small values.
}
\examples{
require(umx)
data(demoOneFactor)
manifests = names(demoOneFactor)

m1 = umxRAM("One Factor", data = demoOneFactor, type = "cov",
	umxPath("G", to = manifests),
	umxPath(var = manifests),
	umxPath(var = "G", fixedAt = 1.0)
)

# ===================================
# = Show the residuals of the model =
# ===================================
residuals(m1)
# |   |x1   |x2    |x3   |x4    |x5 |
# |:--|:----|:-----|:----|:-----|:--|
# |x1 |.    |.     |0.01 |.     |.  |
# |x2 |.    |.     |0.01 |-0.01 |.  |
# |x3 |0.01 |0.01  |.    |.     |.  |
# |x4 |.    |-0.01 |.    |.     |.  |
# |x5 |.    |.     |.    |.     |.  |
# [1] "nb: You can zoom in on bad values with, e.g. suppress = .01, which
#      will hide values smaller than this. Use digits = to round"

residuals(m1, digits = 3)
residuals(m1, digits = 3, suppress = .005)
# residuals are returned as an invisible object you can capture in a variable
a = residuals(m1); a
}
\references{
\itemize{
\item \url{https://tbates.github.io},  \url{https://github.com/tbates/umx}
}
}
\seealso{
Other Reporting functions: \code{\link{RMSEA.MxModel}()},
  \code{\link{RMSEA.summary.mxmodel}()},
  \code{\link{RMSEA}()},
  \code{\link{extractAIC.MxModel}()},
  \code{\link{loadings}()}, \code{\link{umxCI_boot}()},
  \code{\link{umxCI}()}, \code{\link{umxCompare}()},
  \code{\link{umxConfint}()}, \code{\link{umxExpCov}()},
  \code{\link{umxExpMeans}()},
  \code{\link{umxFitIndices}()},
  \code{\link{umxPlotACEv}()}, \code{\link{umxRotate}()},
  \code{\link{umxSummary.MxModel}()}
}
\concept{Reporting functions}
