% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.R
\name{umxPath}
\alias{umxPath}
\title{Easier (and powerful) specification of paths in SEM.}
\usage{
umxPath(
  from = NULL,
  to = NULL,
  with = NULL,
  var = NULL,
  cov = NULL,
  means = NULL,
  v1m0 = NULL,
  v.m. = NULL,
  v0m0 = NULL,
  v.m0 = NULL,
  v0m. = NULL,
  fixedAt = NULL,
  freeAt = NULL,
  firstAt = NULL,
  unique.bivariate = NULL,
  unique.pairs = NULL,
  fromEach = NULL,
  forms = NULL,
  Cholesky = NULL,
  defn = NULL,
  connect = c("single", "all.pairs", "all.bivariate", "unique.pairs", "unique.bivariate"),
  arrows = 1,
  free = TRUE,
  values = NA,
  labels = NA,
  lbound = NA,
  ubound = NA,
  hasMeans = NULL
)
}
\arguments{
\item{from}{One or more source variables e.g "A" or c("A","B")}

\item{to}{One or more target variables for one-headed paths, e.g "A" or c("A","B").}

\item{with}{2-headed path <--> from 'from' to 'with'.}

\item{var}{Equivalent to setting 'from' and 'arrows' = 2. nb: from, to, and with must be left empty.}

\item{cov}{Convenience to allow 2 variables to covary (equivalent to 'from' and 'with'). nb: leave from, to, etc. empty}

\item{means}{equivalent to "from = 'one', to = x. nb: from, to, with and var must be left empty (their default).}

\item{v1m0}{variance of 1 and mean of zero in one call.}

\item{v.m.}{variance and mean, both free.}

\item{v0m0}{variance and mean, both fixed at zero.}

\item{v.m0}{variance free, mean fixed at zero.}

\item{v0m.}{variance fixed at 0, mean free.}

\item{fixedAt}{Equivalent to setting "free = FALSE, values = fixedAt"}

\item{freeAt}{Equivalent to setting "free = TRUE, values = freeAt"}

\item{firstAt}{First path is fixed at this value (free is ignored: warning if other than a single TRUE)}

\item{unique.bivariate}{equivalent to setting from, and "connect = "unique.bivariate", arrows = 2".
nb: from, to, and with must be left empty (their default)}

\item{unique.pairs}{equivalent to setting "connect = "unique.pairs", arrows = 2" (don't use from, to, or with)}

\item{fromEach}{Like all.bivariate, but with one head arrows. 'to' can be set.}

\item{forms}{Build a formative variable. 'from' variables form the latent.
Latent variance is fixed at 0. Loading of path 1 is fixed at 1. unique.bivariate between 'from' variables.}

\item{Cholesky}{Treat \strong{Cholesky} variables as latent and \strong{to} as measured, and connect as in an ACE model.}

\item{defn}{Implements a definition variable as a latent with zero variance & mean and labeled 'data.defVar'}

\item{connect}{as in mxPath - nb: from and to must also be set.}

\item{arrows}{as in mxPath - nb: from and to must also be set.}

\item{free}{whether the value is free to be optimised}

\item{values}{default value list}

\item{labels}{labels for each path}

\item{lbound}{lower bounds for each path value}

\item{ubound}{upper bounds for each path value}

\item{hasMeans}{Used in 'forms' case to know whether the data have means or not.}
}
\value{
\itemize{
\item 1 or more \code{\link[=mxPath]{mxPath()}}s
}
}
\description{
This function is used to easily and compactly specify paths in models. In addition to
\code{from} and \code{to}, it adds specialised parameters for variances (var), two headed paths (with) and means (mean).
There are also new terms to describe fixing values: \code{fixedAt} and \code{fixFirst}.
To give a couple of the most common, time-saving examples:
\itemize{
\item \code{umxPath("A", with = "B",  fixedAt = 1)}
\item \code{umxPath(var = c("A", "B"),  fixedAt = 1)}
\item \code{umxPath(v.m. = manifests)}
\item \code{umxPath(v1m0 = latents)}
\item \code{umxPath(v1m0 = latents)}
\item \code{umxPath(means = manifests)}
\item \code{umxPath(fromEach = c('A',"B","C"), to = c("y1","y2"))}
\item \code{umxPath(unique.bivariate = c('A',"B","C"))}
\item \code{umxPath("A", to = c("B","C","D"),  firstAt = 1)}
}
}
\details{
\code{umxPath} introduces the following new words to your path-defining vocabulary: \code{with}, \code{var}, \code{cov}, \code{means}, \code{v1m0},
\code{v0m0}, \code{v.m0}, \code{v.m}, \code{fixedAt}, \code{freeAt}, \code{firstAt}, \code{unique.bivariate}, \code{unique.pairs}, \code{fromEach}, \code{Cholesky}, \code{defn}, \code{forms}.

\code{with} creates covariances (2-headed paths):
\code{umxPath(A, with = B)}

Specify a variance for A with
\code{umxPath(var = "A")}.

Of course you can use vectors anywhere:
\code{umxPath(var = c('N','E', 'O'))}

To specify a mean, you just say:
\code{umxPath(mean = "A")}, which is equivalent to \code{mxPath(from = "one", to = "A")}.

To fix a path at a value, you can say:
\code{umxPath(var = "A", fixedAt = 1)}

The common task of creating a variable with variance fixed at 1 and mean at 0 is done thus:
\code{umxPath(v1m0 = "A")}

For free variance and means use:
\code{umxPath(v.m. = "A")}

\code{umxPath} exposes \code{unique.bivariate} and \code{unique.pairs}, So to create paths A<->A, B<->B,
and A->B, you would say:
\code{umxPath(unique.pairs = c('A',"B"))}

To create paths A<->B, B<->C, and A<->C, you would say:
\code{umxPath(unique.bivariate = c('A',"B","C"))}

Creates one-headed arrows on the all.bivariate pattern
\code{umxPath(fromEach = c('A',"B","C"))}

Setting up a latent trait, you can scale with a fixed first path thus:

\code{umxPath("A", to = c("B","C","D"),  firstAt = 1)}

To create Cholesky-pattern connections:

\verb{umxPath(Cholesky = c("A1", "A2"), to c("var1", "var2"))}
}
\examples{

# ==========================================
# = Examples of each path type, and option =
# ==========================================

umxPath("A", to = "B") # One-headed path from A to B
umxPath("A", to = "B", fixedAt = 1) # same, with value fixed @1
umxPath("A", to = c("B", "C"), fixedAt = 1:2) # same, with more than 1 value
umxPath("A", to = c("B","C"), firstAt = 1) # Fix only the first path, others free
umxPath(var = "A") # Give a variance to A
umxPath(var = "A", fixedAt = 1) # Give A variance, fixed at 1
umxPath(means = c("A","B")) # Create a means model for A: from = "one", to = "A"
umxPath(v1m0 = "A") # Give "A" variance and a mean, fixed at 1 and 0 respectively
umxPath(v.m. = "A") # Give "A" variance and a mean, leaving both free.
umxPath(v0m0 = "W", label = c(NA, "data.W"))
umxPath("A", with = "B") # using with: same as "to = B, arrows = 2"
umxPath("A", with = "B", fixedAt = .5) # 2-head path fixed at .5
umxPath("A", with = c("B", "C"), firstAt = 1) # first covariance fixed at 1
umxPath(cov = c("A", "B"))  # Covariance A <-> B
umxPath(defn = "mpg") # create latent called def_mpg, with 0 mean * var, and label = "data.mpg"
umxPath(fromEach = c('a','b'), to = c('c','d')) # a->c, a<->d, b<->c, b<->d
umxPath(unique.bivariate = c('a','b','c')) # bivariate paths a<->b, a<->c, b<->c etc.
umxPath(unique.pairs = letters[1:3]) # all distinct pairs: a<->a, a<->b, a<->c, b<->b, etc.
umxPath(Cholesky = c("A1","A2"), to = c("m1", "m2")) # Cholesky

\dontrun{
# A worked example
data(demoOneFactor)
manifests = names(demoOneFactor)
m1 = umxRAM("One Factor", data = demoOneFactor, type= "cov",
	umxPath("G", to = manifests),
	umxPath(var = manifests),
	umxPath(var = "G", fixedAt = 1.0)
)
umxSummary(m1, std = TRUE)
require(umx)


# ====================
# = Cholesky example =
# ====================
# ======================================================================
# = 3-factor Cholesky (A component of a 5-variable 3-factor ACE model) =
# ======================================================================
latents   = paste0("A", 1:3)
manifests = names(demoOneFactor)
m1 = umxRAM("Chol", data = demoOneFactor, type = "cov",
	umxPath(Cholesky = latents, to = manifests),
	umxPath(var = manifests),
	umxPath(var = latents, fixedAt = 1)
)
plot(m1, splines= FALSE)

# =========================================================
# = Definition variable example.Not much use at present,  =
# = as def vars are not readily used in RAM models...     =
# = Working on something rational and intuitive.          =
# =========================================================
data(mtcars)
m1 = umxRAM("manifest", data = mtcars,
 umxPath(v.m. = "mpg"),
 umxPath(defn = "mpg")
)

}

}
\references{
\itemize{
\item \url{https://tbates.github.io}
}
}
\seealso{
\itemize{
\item \code{\link[=mxPath]{mxPath()}}
}

Other Core Model Building Functions: 
\code{\link{umxMatrix}()},
\code{\link{umxModify}()},
\code{\link{umxRAM}()},
\code{\link{umxSuperModel}()},
\code{\link{umx}}
}
\concept{Core Model Building Functions}
