% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxPlotGxE}
\alias{umxPlotGxE}
\alias{plot.MxModelGxE}
\title{Plot the results of a GxE univariate test for moderation of ACE components.}
\usage{
umxPlotGxE(
  x,
  xlab = NA,
  location = "topleft",
  separateGraphs = FALSE,
  acergb = c("red", "green", "blue", "black"),
  gg = TRUE,
  moderatorValues = NULL,
  ...
)
}
\arguments{
\item{x}{A fitted \code{\link[=umxGxE]{umxGxE()}} model to plot}

\item{xlab}{String to use for the x label (default = NA, which will use the variable name)}

\item{location}{Where to plot the legend (default = "topleft")
see ?legend for alternatives like bottomright}

\item{separateGraphs}{(default = FALSE)}

\item{acergb}{Colors to use for plot c(a = "red", c = "green", e = "blue", tot = "black")}

\item{gg}{Use ggplot2 (default = TRUE)}

\item{moderatorValues}{If you want to pass in your own list of moderator values instead of the real ones in the data (Default = NULL)}

\item{...}{Optional additional parameters}
}
\value{
None
}
\description{
Plot GxE results (univariate environmental moderation of ACE components).
Options include plotting the raw and standardized graphs separately, or in a combined panel.
You can also set the label for the x axis (xlab), and choose the location of the legend.
}
\details{
\emph{note}: If \code{gg=TRUE}, the plots are drawn in ggplot, and also returned as a \code{list(raw, std)} so you can edit them.
}
\examples{
\dontrun{
require(umx)
data(twinData)
twinData$age1 = twinData$age2 = twinData$age
mzData = subset(twinData, zygosity == "MZFF")
dzData = subset(twinData, zygosity == "DZFF")
m1= umxGxE(selDVs= "bmi", selDefs= "age", dzData= dzData, mzData= mzData, sep="", tryHard="yes")
plot(m1)
# Directly call umxPlotGxE
umxPlotGxE(m1, xlab = "Age", separateGraphs = TRUE, gg = FALSE)
umxPlotGxE(m1, moderatorValues=18:67)
}

}
\references{
\itemize{
\item \url{https://tbates.github.io}
}
}
\seealso{
\itemize{
\item \code{\link[=plot]{plot()}}, \code{\link[=umxSummary]{umxSummary()}} work for IP, CP, GxE, SAT, and ACE models.
}

\itemize{
\item \code{\link[=umxGxE]{umxGxE()}}
}

Other Plotting functions: 
\code{\link{ggAddR}()},
\code{\link{plot.MxLISRELModel}()},
\code{\link{plot.MxModel}()},
\code{\link{plot.MxModelTwinMaker}()},
\code{\link{umx}},
\code{\link{umxPlot}()},
\code{\link{umxPlotACE}()},
\code{\link{umxPlotACEcov}()},
\code{\link{umxPlotACEv}()},
\code{\link{umxPlotCP}()},
\code{\link{umxPlotDoC}()},
\code{\link{umxPlotFun}()},
\code{\link{umxPlotGxEbiv}()},
\code{\link{umxPlotIP}()},
\code{\link{umxPlotSexLim}()},
\code{\link{umxPlotSimplex}()}
}
\concept{Plotting functions}
