% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxSummaryACE}
\alias{umxSummaryACE}
\alias{umxSummary.MxModelACE}
\title{Shows a compact, publication-style, summary of a umx Cholesky ACE model}
\usage{
umxSummaryACE(
  model,
  digits = 2,
  comparison = NULL,
  std = TRUE,
  showRg = FALSE,
  CIs = TRUE,
  report = c("markdown", "html"),
  file = getOption("umx_auto_plot"),
  returnStd = FALSE,
  extended = FALSE,
  zero.print = ".",
  ...
)
}
\arguments{
\item{model}{an \code{\link[OpenMx:mxModel]{OpenMx::mxModel()}} to summarize.}

\item{digits}{round to how many digits (default = 2).
Defaults to NA = do not create plot output.}

\item{comparison}{you can run mxCompare on a comparison model (NULL).}

\item{std}{Whether to standardize the output (default = TRUE).}

\item{showRg}{= whether to show the genetic correlations (FALSE).}

\item{CIs}{Whether to show Confidence intervals if they exist (TRUE).}

\item{report}{If "html", then open an html table of the results.}

\item{file}{The name of the dot file for figure: "name" = use the name of the model.}

\item{returnStd}{Whether to return the standardized form of the model (default = FALSE).}

\item{extended}{how much to report (FALSE).}

\item{zero.print}{How to show zeros (".")}

\item{...}{Other parameters to control model summary.}
}
\value{
\itemize{
\item optional \code{\link[OpenMx:mxModel]{OpenMx::mxModel()}}
}
}
\description{
Summarize a fitted Cholesky model returned by \code{\link[=umxACE]{umxACE()}}. Can control digits, report comparison model fits,
optionally show the Rg (genetic and environmental correlations), and show confidence intervals. the report parameter allows
drawing the tables to a web browser where they may readily be copied into non-markdown programs like Word.
}
\details{
See documentation for other umx models here: \code{\link[=umxSummary]{umxSummary()}}.
}
\examples{
\dontrun{
require(umx)
data(twinData)
selDVs = c("bmi1", "bmi2")
mzData = subset(twinData, zygosity == "MZFF")
dzData = subset(twinData, zygosity == "DZFF")
m1 = umxACE(selDVs = selDVs, dzData = dzData, mzData = mzData)
umxSummary(m1)
umxSummaryACE(m1, file = NA);
umxSummaryACE(m1, file = "name", std = TRUE)
stdFit = umxSummaryACE(m1, returnStd = TRUE);
}

}
\references{
\itemize{
\item \url{https://tbates.github.io},  \url{https://github.com/tbates/umx}
}
}
\seealso{
\itemize{
\item \code{\link[=umxACE]{umxACE()}}, \code{\link[=plot.MxModelACE]{plot.MxModelACE()}}, \code{\link[=umxModify]{umxModify()}}
}

Other Twin Modeling Functions: 
\code{\link{power.ACE.test}()},
\code{\link{umx}},
\code{\link{umxACE}()},
\code{\link{umxACEcov}()},
\code{\link{umxACEv}()},
\code{\link{umxCP}()},
\code{\link{umxDiffMZ}()},
\code{\link{umxDiscTwin}()},
\code{\link{umxDoC}()},
\code{\link{umxDoCp}()},
\code{\link{umxGxE}()},
\code{\link{umxGxE_window}()},
\code{\link{umxGxEbiv}()},
\code{\link{umxIP}()},
\code{\link{umxMRDoC}()},
\code{\link{umxReduce}()},
\code{\link{umxReduceACE}()},
\code{\link{umxReduceGxE}()},
\code{\link{umxRotate.MxModelCP}()},
\code{\link{umxSexLim}()},
\code{\link{umxSimplex}()},
\code{\link{umxSummarizeTwinData}()},
\code{\link{umxSummaryACEv}()},
\code{\link{umxSummaryDoC}()},
\code{\link{umxSummaryGxEbiv}()},
\code{\link{umxSummarySexLim}()},
\code{\link{umxSummarySimplex}()},
\code{\link{umxTwinMaker}()}
}
\concept{Twin Modeling Functions}
