% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pclm_graphics.R
\name{plot.pclm2D}
\alias{plot.pclm2D}
\title{Generic Plot for pclm2D Class}
\usage{
\method{plot}{pclm2D}(
  x,
  color = c(1, 2),
  alpha = c(1, 0.5),
  axes = TRUE,
  box = TRUE,
  xlab = "x-axis",
  ylab = "y-axis",
  zlab = "z-axis",
  main = "",
  sub = "",
  ...
)
}
\arguments{
\item{x}{an object of class \code{\link{pclm2D}}}

\item{color}{
    vector of R color characters. Represents the diffuse component in case of lighting calculation (lit = TRUE),
    otherwise it describes the solid color characteristics.
  }

\item{alpha}{ 
    vector of alpha values between 0.0 (fully transparent) .. 1.0 (opaque).
  }

\item{axes}{add axes to the plot. Logical. Default: \code{TRUE}.}

\item{box}{draw a box around the plot. Logical. Default: \code{TRUE}.}

\item{xlab}{ the axis labels for the plot }

\item{ylab}{ the axis labels for the plot }

\item{zlab}{ the axis labels for the plot }

\item{main}{ the main title for the plot }

\item{sub}{ the subtitle for the plot }

\item{...}{Any of the arguments above can be passed to 
\code{\link{surface3d}}.}
}
\description{
The generic plot for a \code{pclm2D} object is constructed using 
\code{\link{rgl}} package. And can be modified/improved using the \code{rgl} 
tools implemented in the package like: \code{\link{surface3d}}, 
\code{\link{axes3d}}, \code{\link{aspect3d}}, \code{\link{title3d}} or 
\code{\link{snapshot3d}}.For A complete guide to 3D visualization using 
\code{rgl} see 
\href{http://www.sthda.com/english/wiki/a-complete-guide-to-3d-visualization-device-system-in-r-r-software-and-data-visualization}{this tutorial}.
}
\examples{
# See complete examples in pclm2D help page
}
\seealso{
\code{\link{pclm2D}} \code{\link{surface3d}} \code{\link{axes3d}}
\code{\link{aspect3d}} \code{\link{title3d}} \code{\link{snapshot3d}}
}
