% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MortalitySmooth_fun.R
\name{MortSmooth_bbase}
\alias{MortSmooth_bbase}
\title{Construct B-spline basis}
\usage{
MortSmooth_bbase(x, xl, xr, ndx, deg)
}
\arguments{
\item{x}{vector for the abscissa of data;}

\item{xl}{left boundary;}

\item{xr}{right boundary;}

\item{ndx}{number of internal knots minus one or number of internal intervals;}

\item{deg}{degree of the splines.}
}
\value{
A matrix containing equally-spaced B-splines of degree deg along 
x for each column.
}
\description{
This is an internal function of package MortalitySmooth which creates 
equally-spaced B-splines basis over an abscissa of data.
}
\details{
The function reproduce an algorithm presented by Eilers and Marx 
(2010) using differences of truncated power functions 
(see MortSmooth_tpower). The final matrix has a single B-spline for each 
of the [ndx + deg] columns. The number of rows is equal to the length of x.

The function differs from bs in the package splines since it automatically 
constructed B-splines with identical shape. This would allow a simple 
interpretation of coefficients and application of simple differencing.
}
\author{
Carlo G Camarda
}
\keyword{internal}
