% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dartmouth.R
\docType{data}
\name{dartmouth_3}
\alias{dartmouth_3}
\title{Tertiary colors of Dartmouth College, USA}
\format{
An object of class \code{character} of length 10.
}
\source{
Color definitions are based on 
\href{https://communications.dartmouth.edu/visual-identity/design-elements/color-palette}{Dartmouth's visual identity guide}.
}
\usage{
dartmouth_3
}
\value{
A names vector of colors (HEX/HTML codes of type character).
}
\description{
\code{dartmouth_3} provides the ten tertiary colors
of the \href{https://home.dartmouth.edu}{Dartmouth College}, USA.
}
\details{
The 10 tertiary colors are 
\code{"autumn_brown"} (defined as HEX #643c20), 
\code{"bonfire_red"} (defined as HEX #9d162e), 
\code{"tuck_orange"} (defined as HEX #e32d1c), 
\code{"summer_yellow"} (defined as HEX #f5dc96), 
\code{"spring_green"} (defined as HEX #c4dd88), 
\code{"rich_spring_green"} (defined as HEX #a5d75f), 
\code{"river_navy"} (defined as HEX #003c73), 
\code{"river_blue"} (defined as HEX #267aba), 
\code{"web_violet"} (defined as HEX #8a6996), and 
\code{"bonfire_orange"} (defined as HEX #ffa00f). 

\code{dartmouth_3} uses the HEX color definitions.
}
\examples{
dartmouth_3
unikn::seecol(dartmouth_3, main = "Dartmouth College 3") # view color palette

}
\seealso{
\code{\link{dartmouth_1}} for the primary color of Dartmouth College; 
\code{\link{dartmouth_3}} for the tertiary colors of Dartmouth College; 
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other university color palettes.: 
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{dartmouth_2}},
\code{\link{limerick_2}},
\code{\link{notredame_2}},
\code{\link{trinity_2}},
\code{\link{uci_2}},
\code{\link{uflorida_2}},
\code{\link{vanderbilt_2}}
}
\author{
\strong{unicol}, 2320-07-13.
}
\concept{university color palettes.}
\keyword{datasets}
