% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UCSD.R
\docType{data}
\name{UCSD_2}
\alias{UCSD_2}
\title{Accent colors of the University of California San Diego (UCSD), USA}
\format{
An object of class \code{character} of length 6.
}
\source{
Color definitions are based on the
\href{https://brand.ucsd.edu/visual-brand/color/index.html}{Color manual}.
}
\usage{
UCSD_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{UCSD_2} provides six accent colors
of the \href{https://www.UCSD.edu}{UCSD, UC San Diego, University of California}, USA.
}
\details{
The 6 accent colors are
\code{"turquoise"} (defined as CMYK 70/0/16/0, RGB R0/198/215, HEX #00C6D7),
\code{"magenta"} (defined as CMYK 13/83/0/0, RGB R212/98/173, HEX #D462AD),
\code{"sand"} (defined as CMYK 4/6/10/0, RGB R245/240/230, HEX #F5F0E6),
\code{"citron"} (defined as CMYK 3/0/90/0, RGB R243/229/0, HEX #F3E500),
\code{"orange"} (defined as CMYK 0/51/100/0, RGB R252/137/0, HEX #FC8900), and
\code{"green"} (defined as CMYK 60/23/92/5, RGB R110/150/59, HEX #6E963B).

\code{UCSD_2} uses the HEX color definitions.


\href{https://www.UCSD.edu}{UCSD}'s palette of accent colors have been developed 
to add energy to and amplify the UC San Diego brand.

Inspired by our vibrant natural surroundings, accent colors can be used in conjunction with our core
colors to create materials that push boundaries while still recognizable as UC San Diego.
}
\examples{
UCSD_2
unikn::seecol(UCSD_2, main = "accent colors UCSD") # view color palette

}
\seealso{
\code{\link{UCSD_1}} for core colors of UC San Diego;
\code{\link{UCSD_3}} for neutral colors of UC San Diego;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{CMU_1_core}},
\code{\link{CMU_2_tartan}},
\code{\link{CMU_3_campus}},
\code{\link{UCLA_1}},
\code{\link{UCLA_2}},
\code{\link{UCLA_3}},
\code{\link{UCLA_4}},
\code{\link{UCSD_1}},
\code{\link{UCSD_3}},
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{columbia}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_accent}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_1}},
\code{\link{minnesotatwin_2}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_1}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_1}},
\code{\link{stanford_2_accent}},
\code{\link{stanford_3_web}},
\code{\link{uchicago_1}},
\code{\link{uchicago_2}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{uci_4}},
\code{\link{uflorida_1}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_2}},
\code{\link{umass_neutrals}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2023-06-16.
}
\concept{U.S. university color palettes}
\keyword{datasets}
