% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UChicago.R
\docType{data}
\name{uchicago_2}
\alias{uchicago_2}
\title{Accent colors of the University of Chicago, USA}
\format{
An object of class \code{character} of length 23.
}
\source{
Color definitions are based on \href{https://www.uchicago.edu}{UChicago}'s 
\href{https://creative.uchicago.edu/resources/}{Brand Identity Guidelines}.
}
\usage{
uchicago_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uchicago_2} provides the 21 accent colors
of the \href{https://www.uchicago.edu}{University of Chicago}, USA.
}
\details{
\code{"goldenrod"} (defined as Pantone 124C, CMYK 0/25/100/4, RGB 234/170/0, or HEX #EAAA00),
\code{"light goldenrod"} (defined as Pantone 129C, CMYK 0/12/90/0, RGB 243/208/62, or HEX #F3D03E),
\code{"dark goldenrod"} (defined as Pantone 131C, CMYK 3/36/100/11, RGB 204/138/0, or HEX #CC8A00),
\code{"terracotta"} (defined as Pantone 138C, CMYK 0/46/100/6, RGB 222/124/0, or HEX #DE7C00),
\code{"light terracotta"} (defined as Pantone 157C, CMYK 0/37/74/0, RGB 236/161/84, or HEX #ECA154),
\code{"dark terracotta"} (defined as Pantone 1675C, CMYK 5/71/100/27, RGB 169/67/30, or HEX #A9431E),
\code{"ivy"} (defined as Pantone 576C, CMYK 44/4/88/22, RGB 120/157/74, or HEX #789D4A),
\code{"light ivy"} (defined as Pantone 577C, CMYK 29/2/58/2, RGB 169/196/127, or HEX #A9C47F),
\code{"dark ivy"} (defined as Pantone 574C, CMYK 52/20/98/66, RGB 19/48/28, or HEX #13301C),
\code{"forest"} (defined as Pantone 7483C, CMYK 82/15/85/50, RGB 39/93/56, or HEX #275D38),
\code{"light forest"} (defined as Pantone 7494C, CMYK 31/6/42/16, RGB 156/175/136, or HEX #9CAF88),
\code{"dark forest"} (defined as Pantone 553C, CMYK 72/28/65/74, RGB 40/71/52, or HEX #284734),
\code{"lake"} (defined as Pantone 633C, CMYK 100/7/10/31, RGB 0/115/150, or HEX #007396),
\code{"light lake"} (defined as Pantone 631C, CMYK 70/0/15/2, RGB 62/177/200, or HEX #3EB1C8),
\code{"dark lake"} (defined as Pantone 303C, CMYK 100/55/18/76, RGB 0/42/58, or HEX #002A3A),
\code{"violet"} (defined as Pantone 519C, CMYK 63/90/9/50, RGB 89/49/95, or HEX #59315F),
\code{"light violet"} (defined as Pantone 5205C, CMYK 25/42/13/43, RGB 134/100/122, or HEX #86647A),
\code{"dark violet"} (defined as Pantone 7449C, CMYK 63/96/21/83, RGB 65/39/59, or HEX #41273B),
\code{"brick"} (defined as Pantone 1807C, CMYK 6/85/71/30, RGB 164/52/58, or HEX #A4343A),
\code{"light brick"} (defined as Pantone 7522C, CMYK 10/58/54/18, RGB 180/106/85, or HEX #B46A55), and
\code{"dark brick"} (defined as Pantone 1817C, CMYK 20/70/59/60, RGB 100/51/53, or HEX #643335).

\code{uchicago_2} uses the HEX color definitions.


The secondary palette is to be used sparingly and always in conjunction with the primary palette. 
In other words, all print and digital communications will utilize the primary palette as the dominant color scheme, 
with the secondary color palette providing subtle accent color options.
}
\examples{
uchicago_2
unikn::seecol(uchicago_2, main = "Accent colors of UChicago") # view color palette

}
\seealso{
\code{\link{uchicago_1}} for primary colors of University of Chicago;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{CMU_1_core}},
\code{\link{CMU_2_tartan}},
\code{\link{CMU_3_campus}},
\code{\link{UCLA_1}},
\code{\link{UCLA_2}},
\code{\link{UCLA_3}},
\code{\link{UCLA_4}},
\code{\link{UCSD_1}},
\code{\link{UCSD_2}},
\code{\link{UCSD_3}},
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{columbia}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_accent}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_1}},
\code{\link{minnesotatwin_2}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_1}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_1}},
\code{\link{stanford_2_accent}},
\code{\link{stanford_3_web}},
\code{\link{uchicago_1}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{uci_4}},
\code{\link{uflorida_1}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_2}},
\code{\link{umass_neutrals}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2023-06-14.
}
\concept{U.S. university color palettes}
\keyword{datasets}
