% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StAndrews.R
\docType{data}
\name{standrews_2}
\alias{standrews_2}
\title{Secondary colours of the University of St Andrews, Scotland}
\format{
An object of class \code{character} of length 8.
}
\source{
Colour definitions are based on \href{https://www.st-andrews.ac.uk}{St Andrews}' 
\href{https://www.st-andrews.ac.uk/brand/design-guidelines/colours/}{design guidelines}.
}
\usage{
standrews_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{standrews_2} provides the eight secondary colours 
of the \href{https://www.st-andrews.ac.uk}{University of St Andrews}, Scotland.
}
\details{
The 8 secondary colours are 
\code{"light blue"} (defined as HEX #00aeef), 
\code{"mid blue"} (defined as HEX #007dc5),
\code{"burgundy"} (defined as HEX #c60c46),
\code{"purple"} (defined as HEX #7b439a)
\code{"orange"} (defined as HEX #f5842b),
\code{"green"} (defined as HEX #54b948), 
\code{"mid green"} (defined as HEX #00853f), and 
\code{"dark green"} (defined as HEX #005953).

\code{standrews_2} uses these HEX colour definitions.
}
\examples{
standrews_2
unikn::seecol(standrews_2, main = "Secondary colours of St Andrews") # view palette

}
\seealso{
\code{\link{standrews_1}} for primary colours of St. Andrews; 
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Scottish university color palettes: 
\code{\link{dundee_background}},
\code{\link{dundee_block}},
\code{\link{dundee_core}},
\code{\link{dundee_highlight}},
\code{\link{edinburgh}},
\code{\link{standrews_1}},
\code{\link{stirling_1}},
\code{\link{stirling_2}},
\code{\link{stirling_3}}
}
\author{
\strong{unicol}, 2023-07-16.
}
\concept{Scottish university color palettes}
\keyword{datasets}
