% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kassel.R
\docType{data}
\name{uni_kassel}
\alias{uni_kassel}
\title{Colors of the University of Kassel, Germany}
\format{
An object of class \code{character} of length 11.
}
\source{
Color definitions are based on the \href{https://www.uni-kassel.de/uni/}{Uni Kassel}'s 
\href{https://www.uni-kassel.de/hochschulverwaltung/themen/toolbox-oeffentlichkeitsarbeit/corporate-design-und-medienservice}{CD und Medienservice} page.
}
\usage{
uni_kassel
}
\value{
A names vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uni_kassel} provides the eleven primary colors
of the \href{https://www.uni-kassel.de/uni/}{University of Kassel}, Germany.
}
\details{
The 11 primary colors are 
\code{"k80"} (defined as HEX #575757), 
\code{"k50"} (defined as HEX #9D9D9D), 
\code{"k20"} (defined as HEX #DADADA), 
\code{"hks28+k30"} (defined as HEX #9A0C46), 
\code{"hks28"} (defined as HEX #C7105C), 
\code{"hks28-20"} (defined as HEX #F3D8DD), 
\code{"dunkelgruen"} (defined as HEX #153824), 
\code{"hellblau"} (defined as HEX #5095C8), 
\code{"gelbgruen"} (defined as HEX #C4D20F), 
\code{"hellgruen"} (defined as HEX #4AAC96), and 
\code{"goldgelb"} (defined as HEX #EAC372).

\code{uni_kassel} uses the HEX color definitions.
}
\examples{
uni_kassel
unikn::seecol(uni_kassel, main = "Colors of the University of Kassel, Germany")  # view palette

}
\seealso{
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other German university color palettes: 
\code{\link{fu_0}},
\code{\link{fu_1}},
\code{\link{fu_2}},
\code{\link{fu_3}},
\code{\link{hu_1}},
\code{\link{hu_1_2022}},
\code{\link{hu_1_digital}},
\code{\link{hu_2}},
\code{\link{hu_2_2022}},
\code{\link{hu_3_accent}},
\code{\link{lmu_1}},
\code{\link{lmu_2}},
\code{\link{lmu_3}},
\code{\link{rptu}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_halle}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_heidelberg}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_magdeburg_1}},
\code{\link{uni_magdeburg_2}},
\code{\link{uni_magdeburg_3}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_potsdam}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_stuttgart_1}},
\code{\link{uni_stuttgart_print}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unicol}, 2023-07-16.
}
\concept{German university color palettes}
\keyword{datasets}
