% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_def_1.R
\docType{data}
\name{pal_petrol}
\alias{pal_petrol}
\title{uni.kn petrol color palette.}
\format{An object of class \code{data.frame} with 1 rows and 5 columns.}
\usage{
pal_petrol
}
\description{
\code{pal_petrol} provides an additional uni.kn color palette  
as a data frame containing 5 colors (shades of 
\code{\link{Petrol}} or grue).
}
\details{
See \url{https://www.uni-konstanz.de} for details, and 
\url{https://en.wikipedia.org/wiki/New_riddle_of_induction} 
for the portmanteau "grue".
}
\examples{
pal_petrol
dim(pal_petrol)  # 1 5
pal_petrol[4]    # preferred (named) color "petrol4"
pal_petrol[[4]]  # preferred color "petrol4" OR "#077187"

# Plotting palette:
seecol(pal_petrol)

}
\seealso{
\code{\link{pal_unikn}} for the unikn default color palette with all 5 colors of \code{\link{pal_seeblau}}; 
\code{\link{pal_seegruen}} for an alternative green/grue uni.kn color palette;  
\code{\link{pal_unikn_pref}} for a uni.kn color palette with all preferred colors; 
\code{\link{seecol}} to show color palettes;
\code{\link{usecol}} to use color palettes.

Other color palettes: \code{\link{pal_bordeaux}},
  \code{\link{pal_grau}}, \code{\link{pal_karpfenblau}},
  \code{\link{pal_peach}}, \code{\link{pal_pinky}},
  \code{\link{pal_seeblau}}, \code{\link{pal_seegruen}},
  \code{\link{pal_signal}}, \code{\link{pal_unikn_dark}},
  \code{\link{pal_unikn_light}},
  \code{\link{pal_unikn_pair}},
  \code{\link{pal_unikn_ppt}},
  \code{\link{pal_unikn_pref}},
  \code{\link{pal_unikn_web}}, \code{\link{pal_unikn}}
}
\concept{color palettes}
\keyword{datasets}
