% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_def_2.R
\docType{data}
\name{pal_unikn_dark}
\alias{pal_unikn_dark}
\title{uni.kn color palette of dark colors (10 colors)}
\format{
An object of class \code{data.frame} with 1 rows and 10 columns.
}
\usage{
pal_unikn_dark
}
\description{
\code{pal_unikn_dark} provides an additional uni.kn color palette  
that collects 2 dark colors of 5 color palettes  
as a data frame containing 10 colors (in 5 pairs).
}
\details{
See \url{https://www.uni-konstanz.de/en/university/news-and-media/create-online-and-print-media/corporate-design/} for details.
}
\examples{
pal_unikn_dark
dim(pal_unikn_dark)  # 1 8 
pal_unikn_dark[1]    # color "karpfenblau5" by position
pal_unikn_dark[[1]]  # color value by position: #324376"
pal_unikn_dark["karpfenblau5"]  # color value by name

# Viewing/using color palette:
seecol(pal_unikn_dark)
demopal(pal_unikn_dark, type = "points", main = "Dark colors of Konstanz University")

}
\seealso{
\code{\link{pal_unikn_light}} for a lighter uni.kn color palette; 
\code{\link{pal_unikn_pair}} for a pairwise uni.kn color palette; 
\code{\link{pal_unikn}} for the default uni.kn color palette; 
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes.

Other color palettes: 
\code{\link{pal_bordeaux}},
\code{\link{pal_grau}},
\code{\link{pal_karpfenblau}},
\code{\link{pal_peach}},
\code{\link{pal_petrol}},
\code{\link{pal_pinky}},
\code{\link{pal_seeblau}},
\code{\link{pal_seegruen}},
\code{\link{pal_signal}},
\code{\link{pal_unikn_light}},
\code{\link{pal_unikn_pair}},
\code{\link{pal_unikn_ppt}},
\code{\link{pal_unikn_pref}},
\code{\link{pal_unikn_web}},
\code{\link{pal_unikn}}
}
\concept{color palettes}
\keyword{datasets}
