% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pals.R
\docType{data}
\name{uni_jena_1}
\alias{uni_jena_1}
\title{Primary colors of the University of Jena}
\format{
An object of class \code{character} of length 2.
}
\source{
Color definitions are based on 
\url{https://www.uni-jena.de/corporate-design}.
}
\usage{
uni_jena_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uni_jena_1} provides the main \code{dunkelblau} color 
and the auxiliary \code{gold} color 
of the \href{https://www.uni-jena.de/}{University of Jena}, Germany.
}
\details{
The main color \code{dunkelblau} is alternatively defined as 
\code{RGB 0/47/93}, \code{CMYK 100/70/10/50}, or \code{HKS 41 K}. 

The auxiliary color \code{gold} is alternatively defined as 
\code{RGB 174/154/99}, \code{CMYK 20/25/60/25}, or \code{HKS 98 K}. 

See the \code{\link{ac}} and \code{\link{usecol}} functions 
for creating color gradients. 

The full name of the \href{https://www.uni-jena.de/}{University of Jena} 
is Friedrich-Schiller-Universität Jena.
}
\examples{
uni_jena_1
seecol(uni_jena_1, main = "Primary colors of the University of Jena")
demopal(uni_jena_1, type = 2, seed = 5, main = "Primary colors of Jena University")

# Gradient: Mixing the main colors with "white":
jena_mix <- usecol(c(uni_jena_1[1], "white", uni_jena_1[2]), n = 7)
seecol(jena_mix, main = "A gradient of the University of Jena")

}
\seealso{
\code{\link{uni_jena_2}} for departmental colors of the University of Jena;  
\code{\link{seecol}} for viewing and comparing color palettes; 
\code{\link{usecol}} for using color palettes; 
\code{\link{simcol}} for finding similar colors; 
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors.

Other contributed color palettes: 
\code{\link{caltech_pal_1}},
\code{\link{caltech_pal_2}},
\code{\link{caltech_pal_3}},
\code{\link{eth_pal_1}},
\code{\link{eth_pal_2}},
\code{\link{eth_pal_3}},
\code{\link{fu_pal_0}},
\code{\link{fu_pal_1}},
\code{\link{fu_pal_2}},
\code{\link{fu_pal_3}},
\code{\link{hu_pal_1}},
\code{\link{hu_pal_2}},
\code{\link{lmu_pal_1}},
\code{\link{lmu_pal_2}},
\code{\link{lmu_pal_3}},
\code{\link{mpg_pal}},
\code{\link{rpi_pal_1}},
\code{\link{rpi_pal_2}},
\code{\link{rpi_pal_3}},
\code{\link{rptu_pal}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_jena_2}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_princeton_0}},
\code{\link{uni_princeton_1}},
\code{\link{uni_princeton_2}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unikn}, 2023-01-02.
}
\concept{contributed color palettes}
\keyword{datasets}
