% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_fun_1.R
\name{usecol}
\alias{usecol}
\title{Use a color or color palette}
\usage{
usecol(
  pal = pal_unikn,
  n = "all",
  alpha = NA,
  distinct = FALSE,
  use_names = FALSE,
  use_col_ramp = FALSE
)
}
\arguments{
\item{pal}{A color palette (as a vector of colors or color palettes). 
Default: \code{pal = \link{pal_unikn}}.}

\item{n}{An integer value specifying the desired number of colors from the palette. 
Default: \code{n = "all"} (i.e., use all colors of a color palette).  
For the palettes defined by \strong{unikn}, \code{n} is set to a pre-defined selection of 
colors if the desired number of colors is smaller than the available number.  
For all other palettes and values of \code{n} larger than \code{length(pal)}, 
\code{n} compresses or extends the palette using \code{\link{colorRampPalette}}.}

\item{alpha}{A factor modifying the opacity alpha 
(as \code{alpha.f} in \code{\link{adjustcolor}}) to a value in \code{[0, 1]}. 
Default: \code{alpha = NA} (i.e., no modification of opacity).}

\item{distinct}{Boolean: Return only visually distinct colors? 
Default: \code{distinct = FALSE} (i.e., include duplicate colors).}

\item{use_names}{A logical value indicating whether colors should be returned as a named vector.
Default: \code{use_names = FALSE}, for compatibility with \code{ggplot}.}

\item{use_col_ramp}{A logical value specifying whether the default of using pre-selected colors
should be overridden and \code{\link{colorRampPalette}} should be used to process \code{n}. 
Default: \code{use_col_ramp = FALSE}.}
}
\value{
A (named) vector of colors (of type character).
}
\description{
\code{usecol} allows using a color or color palette \code{pal} (e.g., for plotting).
}
\details{
\code{usecol} also allows modifying and combining color palettes in various ways.
}
\examples{
usecol(pal = pal_unikn, n = "all")  # default color palette 
usecol(pal = pal_unikn, n =  4)     # selecting n dedicated colors
usecol(pal = pal_unikn, n = 20)     # extending color palette  

# Mixing a new color palette: 
pal_1 <- usecol(pal = c(rev(pal_seeblau), "white", pal_pinky))  
seecol(pal_1)

# Mixing and extending a color palette: 
pal_2 <- usecol(pal = c(rev(pal_seegruen), "white", pal_bordeaux), n = 20)  
seecol(pal_2)

# Defining and using a custom color palette:
pal_princeton_1 <- c("#E77500", "white", "black")
names(pal_princeton_1) <- c("orange_w", "white", "black")

pal_3 <- usecol(pal_princeton_1, n = 7)
seecol(pal_3)

# Removing visual duplicates:
usecol(c("black", "#000000", "gray", "grey", "red", "red1"), distinct = TRUE)
seecol(usecol(c(pal_unikn, pal_seeblau), distinct = TRUE), title = "Using distinct colors")

}
\seealso{
\code{\link{seecol}} for viewing and comparing color palettes; 
\code{\link{simcol}} for finding similar colors; 
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors; 
\code{\link{shades_of}} to defining shades of a given color; 
\code{\link{ac}} for adjusting color transparency; 
\code{\link{pal_unikn}} for the default uni.kn color palette.

Other color functions: 
\code{\link{ac}()},
\code{\link{demopal}()},
\code{\link{grepal}()},
\code{\link{newpal}()},
\code{\link{seecol}()},
\code{\link{shades_of}()},
\code{\link{simcol}()}
}
\concept{color functions}
