% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.R
\docType{methods}
\name{nextItem,unitizerList-method}
\alias{nextItem,unitizerList-method}
\alias{prevItem,unitizerList-method}
\alias{getItem,unitizerList-method}
\alias{reset,unitizerList-method,}
\alias{done,unitizerList-method}
\title{Iterate through items of a \code{\link{unitizerList}} ObjectJK}
\usage{
\S4method{nextItem}{unitizerList}(x)
}
\arguments{
\item{x}{a \code{\link{unitizerList}} object}
}
\value{
\code{\link{unitizerList}} for \code{getItem},
  an item from the list, which could be anything
}
\description{
Extraction process is a combination of steps:
\enumerate{
  \item Move Internal pointer with \code{nextItem} or \code{prevItem}
  \item Retrieve item \code{getItem}
  \item Check whether we're done iterating with \code{done}
}
\code{done} will return TRUE if the pointer is on either the
first or last entry depending on what direction you are iterating.
If you wish to iterate from the last item forward, you should either
\code{reset} with parameter \code{reverse} set to TRUE, or re-order
the items.
}
\keyword{internal}
