% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mllgamma.R
\name{mllgamma}
\alias{mllgamma}
\title{Log-gamma distribution maximum likelihood estimation}
\usage{
mllgamma(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{na.rm}{logical. Should missing values be removed?}

\item{...}{passed to \code{\link{mlgamma}}.}
}
\value{
\code{mllgamma} returns an object of \link[base:class]{class} \code{univariateML}.
This is a named numeric vector with maximum likelihood estimates for
\code{shapelog} and \code{ratelog} and the following attributes:
\item{\code{model}}{The name of the model.}
\item{\code{density}}{The density associated with the estimates.}
\item{\code{logLik}}{The loglikelihood at the maximum.}
\item{\code{support}}{The support of the density.}
\item{\code{n}}{The number of observations.}
\item{\code{call}}{The call as captured my \code{match.call}}
}
\description{
The maximum likelihood estimate of \code{shapelog} and \code{ratelog} are calculated
by calling \code{\link[=mlgamma]{mlgamma()}} on the transformed data.
}
\details{
For the density function of the log normal distribution see
\link[actuar:Loggamma]{Loggamma}.
}
\examples{
mllgamma(precip)
}
\references{
Hogg, R. V. and Klugman, S. A. (1984), Loss Distributions, Wiley.

Dutang, C., Goulet, V., & Pigeon, M. (2008). actuar: An R package for
actuarial science. Journal of Statistical Software, 25(7), 1-37.
}
\seealso{
\link[actuar:Loggamma]{Loggamma} for the log normal density.
}
