% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimates.R
\name{estimates}
\alias{estimates}
\title{Estimates}
\usage{
estimates(x, ...)
}
\arguments{
\item{x}{An object.}

\item{...}{Other arguments passed to methods.}
}
\value{
A list of uniquely named numeric objects.
}
\description{
Calculates the estimates for an MCMC object.
}
\examples{
\dontshow{if (requireNamespace("nlist", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(nlist)

estimates(nlist(x = 1:9))
estimates(nlist(y = 3:5, zz = matrix(1:9, 3)))
estimates(nlists(nlist(x = 1:3), nlist(x = 2:4)), fun = mean)
\dontshow{\}) # examplesIf}
}
\seealso{
Other MCMC manipulations: 
\code{\link{bind_chains}()},
\code{\link{collapse_chains}()},
\code{\link{split_chains}()}
}
\concept{MCMC manipulations}
