% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unpivotr.R
\docType{package}
\name{unpivotr-package}
\alias{unpivotr}
\alias{unpivotr-package}
\title{Un-pivot complex and irregular data layouts.}
\description{
'Unpivotr' provides tools for converting data from complex or irregular
layouts to a columnar structure.  For example, tables with multi-level column
or row headers, or spreadsheets of several tables, nested HTML tables, and
data that uses several different sentinel values.
}
\details{
The best way to learn unpivotr is the free online book \href{https://nacnudus.github.io/spreadsheet-munging-strategies/}{Spreadsheet MungingStrategies}.

Header and data cells can selected by their contents, position, data type and
formatting, and can be associated with one other by their relative positions.

The input data must be a data frame with the columns 'row' and 'col' to
describe the position of a 'cell' of data.  For cells that are to be
interpreted as data, further columns containing the 'value' of the cell are,
of course, necessary for there to be any point in using this package, though
they are not actually required for any of the given functions.

Data frames and HTML tables can be converted into a format meeting these
requirements by using the \code{\link[=as_cells]{as_cells()}} function.  Excel (.xlsx)
files can be imported directly into the required format with the 'tidyxl'
package, available at \url{https://github.com/nacnudus/tidyxl}, which has the
advantage that it retains cell formatting and comments.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/nacnudus/unpivotr}
  \item Report bugs at \url{https://github.com/nacnudus/unpivotr/issues}
}

}
\author{
\strong{Maintainer}: Duncan Garmonsway \email{nacnudus@gmail.com}

}
