% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upwaver.R
\name{board_details}
\alias{board_details}
\title{Information about a specific board}
\usage{
board_details(organisation, board_id, token)
}
\arguments{
\item{organisation}{A character. The name of the organisation as specified in the URL:
https://<organisation>.upwave.io}

\item{board_id}{An integer. The number of the board you want to inspect as specified in
the URL: https://<organisation>.upwave.io/board/<board_id>/view/}

\item{token}{A character. The API token to access boards on upwave.io. The token can be
obtained by visiting your account settings. Click your profile image, select "Settings"
and find your API-Key in the "Account" tab.}
}
\value{
A list
}
\description{
board_details() is a wrapper around "board_details" as specified in the 'Upwave' API
https://www.upwave.io/api/. It returns detailed information about a specific board such
as id, title, purpose, background image, creation time, creator, columns, rows and colors.
}
\examples{
board_details("4597", 14351, "807a0c3451c04602b4dbfdc0338a65f7")
}
