% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_pipes.R
\name{use_pipes}
\alias{use_pipes}
\title{Use different pipes in your package}
\usage{
use_pipes(path = "R", export = TRUE)
}
\arguments{
\item{path}{(\code{character}) A path pointing at where to copy the file.}

\item{export}{If \code{TRUE}, the file content is exported to \code{NAMESPACE}.}
}
\value{
No return value, called for side effects.
}
\description{
The function adds the useful operators to use in your project. These
operators include:
\itemize{
\item \verb{\%>\%} Forward Pipe operator
\item \verb{\%||\%} NULL operator
}
}
\details{
The function:
\enumerate{
\item Copies a file with several pipes '\code{path}/utils-pipes.R' and
\item Imports the \code{purrr}package in the project DESCRIPTION file
}
}
\examples{
path <- tempfile()
use_pipes(path)
print(readLines(file.path(path, "utils-pipes.R")))

}
