% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemble.R
\name{compute_multilabel_predictions}
\alias{compute_multilabel_predictions}
\alias{utiml_predict_ensemble}
\title{Compute the multi-label ensemble predictions based on some vote schema}
\usage{
compute_multilabel_predictions(predictions, vote.schema = "maj",
  probability = getOption("utiml.use.probs", TRUE))

utiml_predict_ensemble(predictions, vote.schema, probability)
}
\arguments{
\item{predictions}{A list of multi-label predictions (mlresult).}

\item{vote.schema}{Define the way that ensemble must compute the predictions.
The default valid options are:
\describe{
  \item{'avg'}{Compute the mean of probabilities and the bipartitions}
  \item{'maj'}{Compute the majority of votes}
  \item{'max'}{Compute the higher probability for each instance/label}
  \item{'min'}{Compute the lower probability for each instance/label}
}. (Default: 'maj')}

\item{probability}{A logical value. If \code{TRUE} the predicted values are
the score between 0 and 1, otherwise the values are bipartition 0 or 1.}
}
\value{
A mlresult with computed predictions.
}
\description{
Compute the multi-label ensemble predictions based on some vote schema
}
\section{Functions}{
\itemize{
\item \code{utiml_predict_ensemble}: Internal version
}}

\note{
You can create your own vote schema, just create a method that receive
 two matrix (bipartitions and probabilities) and return a list with the
 final bipartions and probabilities.

 Remember that this method will compute the ensemble votes for each label.
 Thus the bipartition and probability matrix passed as argument for this
 method is related with the bipartitions and probabilities for a single
 label.
}
\examples{
\dontrun{
model <- br(toyml, "KNN")
predictions <- list(
 predict(model, toyml[1:10], k=1),
 predict(model, toyml[1:10], k=3),
 predict(model, toyml[1:10], k=5)
)

result <- compute_multilabel_predictions(predictions, "maj")

## Random choice
random_choice <- function (bipartition, probability) {
 cols <- sample(seq(ncol(bipartition)), nrow(bipartition), replace = TRUE)
 list(
   bipartition = bipartition[cbind(seq(nrow(bipartition)), cols)],
   probability = probability[cbind(seq(nrow(probability)), cols)]
 )
}
result <- compute_multilabel_predictions(predictions, "random_choice")
}
}
