% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_ctrl.R
\name{ctrl}
\alias{ctrl}
\title{CTRL model for multi-label Classification}
\usage{
ctrl(mdata, base.algorithm = getOption("utiml.base.algorithm", "SVM"),
  m = 5, validation.size = 0.3, validation.threshold = 0.3, ...,
  predict.params = list(), cores = getOption("utiml.cores", 1),
  seed = getOption("utiml.seed", NA))
}
\arguments{
\item{mdata}{A mldr dataset used to train the binary models.}

\item{base.algorithm}{A string with the name of the base algorithm. (Default:
\code{options("utiml.base.algorithm", "SVM")})}

\item{m}{The max number of Binary Relevance models used in the binary
ensemble. (Default: 5)}

\item{validation.size}{The size of validation set, used internally to prunes
error-prone class labels. The value must be between 0.1 and 0.5.
(Default: 0.3)}

\item{validation.threshold}{Thresholding parameter determining whether any
class label in Y is regarded as error-prone or not. (Default: 0.3)}

\item{...}{Others arguments passed to the base algorithm for all subproblems}

\item{predict.params}{A list of default arguments passed to the predictor
algorithm. (default: \code{list()})}

\item{cores}{The number of cores to parallelize the training. Values higher
than 1 require the \pkg{parallel} package. (Default:
\code{options("utiml.cores", 1)})}

\item{seed}{An optional integer used to set the seed. This is useful when
the method is run in parallel. (Default: \code{options("utiml.seed", NA)})}
}
\value{
An object of class \code{CTRLmodel} containing the set of fitted
  models, including: \describe{
  \item{rounds}{The value passed in the m parameter}
  \item{validation.size}{The value passed in the validation.size parameter}
  \item{validation.threshold}{The value passed in the validation.threshold
     parameter}
  \item{Y}{Name of labels less susceptible to error, according to the
     validation process}
  \item{R}{List of close-related labels related with Y obtained by using
     feature selection technique}
  \item{models}{A list of the generated models, for each label a list of
     models was built based on close-related labels.}
}
}
\description{
Create a binary relevance with ConTRolled Label correlation exploitation
(CTRL) model for multilabel classification.
}
\details{
CTRL employs a two-stage filtering procedure to exploit label correlations
in a controlled manner. In the first stage, error-prone class labels are
pruned from Y to generate the candidate label set for correlation
exploitation. In the second stage, classification models are built for each
class label by exploiting its closely-related labels in the candidate
label set.

Dependencies:
 The degree of label correlations are estimated via supervised feature
   selection techniques. Thus, this implementation use the
   \link[FSelector]{relief} method available in \pkg{FSelector} package.
}
\examples{
model <- ctrl(toyml, "RANDOM")
pred <- predict(model, toyml)

\dontrun{
# Change default values and use 4 CORES
model <- ctrl(toyml, 'C5.0', m = 10, validation.size = 0.4,
              validation.threshold = 0.5, cores = 4)

# Use seed
model <- ctrl(toyml, 'RF', cores = 4, seed = 123)

# Set a parameters for all subproblems
model <- ctrl(dataset$train, 'KNN', k=5)
}
}
\references{
Li, Y., & Zhang, M. (2014). Enhancing Binary Relevance for Multi-label
   Learning with Controlled Label Correlations Exploitation. In 13th Pacific
   Rim International Conference on Artificial Intelligence (pp. 91-103).
   Gold Coast, Australia.
}
\seealso{
Other Transformation methods: \code{\link{brplus}},
  \code{\link{br}}, \code{\link{cc}}, \code{\link{clr}},
  \code{\link{dbr}}, \code{\link{ebr}}, \code{\link{ecc}},
  \code{\link{eps}}, \code{\link{esl}},
  \code{\link{homer}}, \code{\link{lift}},
  \code{\link{lp}}, \code{\link{mbr}}, \code{\link{ns}},
  \code{\link{ppt}}, \code{\link{prudent}},
  \code{\link{ps}}, \code{\link{rakel}},
  \code{\link{rdbr}}, \code{\link{rpc}}
}
