% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_learner.R
\name{mltrain}
\alias{mltrain}
\title{Build transformation models}
\usage{
mltrain(object, ...)
}
\arguments{
\item{object}{A \code{mltransformation} object. This is used as a list and
contains at least five values:
 \describe{
   \item{object$data}{A data.frame with the train data, where the columns are
   the attributes and the rows are the examples.}
   \item{object$labelname}{The name of the class column.}
   \item{object$labelindex}{The column index of the class.}
   \item{object$mldataset}{The name of multi-label dataset.}
   \item{object$mlmethod}{The name of the multi-label method.}
 }
 Others values may be specified by the multi-label method.}

\item{...}{Others arguments passed to the base method.}
}
\value{
A model object. The class of this model can be of any type, however,
 this object will be passed to the respective mlpredict method.
}
\description{
Base classifiers are used to build models to solve the the transformation
problems. To create a new base classifier, two steps are necessary:
\enumerate{
  \item Create a train method
  \item Create a prediction method
}
This section is about how to create the first step: a train method.
To create a new predict model see \code{\link{mlpredict}} documentation.
}
\section{How to create a new train base method}{

First, is necessary to define a name of your classifier, because this name
determines the method name. The base method name must start with
\code{mltrain.base} followed by the designed name, e.g. a \code{'FOO'}
classify must be defined as \code{mltrain.baseFOO} (we suggest always use
upper case names).

Next, your method must receive at least two parameters (\code{object, ...}).
Use \code{object$data[, object$labelindex]} or
\code{object$data[, object$labelname]} to access the labels values and use
\code{object$data[, -object$labelindex]} to access the predictive attributes.
If you need to know which are the multi-label dataset and method, use
\code{object$mldataset} and \code{object$mlmethod}, respectively.

Finally, your method should return a model that will be used by the mlpredict
method. Remember, that your method may be used to build binary and
multi-class models.
}

\examples{
# Create a empty model of type FOO
mltrain.baseFOO <- function (object, ...) {
   mymodel <- list(
     classes = as.character(unique(object$data[, object$labelindex]))
   )
   class(mymodel) <- 'fooModel'
   mymodel
}

# Using this base method with Binary Relevance
brmodel <- br(toyml, 'FOO')

\donttest{

# Create a SVM method using the e1071 package
library(e1071)
mltrain.baseSVM <- function (object, ...) {
   traindata <- object$data[, -object$labelindex]
   labeldata <- object$data[, object$labelindex]
   model <- svm(traindata, labeldata, probability = TRUE, ...)
   model
}
}
}
