% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_vaccineff.R
\name{plot.vaccineff}
\alias{plot.vaccineff}
\title{Function for Extracting Vaccine Effectiveness Plot}
\usage{
\method{plot}{vaccineff}(
  x,
  type = c("loglog", "surv"),
  cumulative = FALSE,
  percentage = FALSE,
  ...
)
}
\arguments{
\item{x}{Object of class \code{vaccineff}.}

\item{type}{Type of plot. Options are \code{loglog} and \code{surv}.}

\item{cumulative}{If \code{TRUE}, the survival curve is shown as cumulative
incidence.}

\item{percentage}{If \code{TRUE}, results are shown on a percentage scale.}

\item{...}{Additional arguments passed to other functions.}
}
\value{
Plot extracted from \code{vaccineff}.
}
\description{
This function creates plots from an object of class
\code{vaccineff}. It returns a Log-Log plot when \code{type = "loglog"},
or a Survival curve when \code{type = "surv"}. Survival plots can be
shown as cumulative incidence (\code{cumulative = TRUE}), and using
percentages (\code{percentage = TRUE}).
}
