% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lyrics.R
\name{lyrics}
\alias{lyrics}
\title{Lyrics of a song.}
\usage{
lyrics(identifier, type, artist, key, message = TRUE)
}
\arguments{
\item{identifier}{The identifier of the song.}

\item{type}{The type of identifier os the song ("name" or "id").}

\item{artist}{The name of the artist/band.}

\item{key}{The apikey.}

\item{message}{Should the function print something if the
required data is not found?}
}
\value{
\code{lyrics} returns a data.frame with information
    about the artist, the song and the texts.
}
\description{
Gives the lyrics text of a song and the translation text,
   when the language of the song its not Portuguese.
}
\details{
The variables returned by the function are extracted with
    the Vagalume API.
}
\examples{

\dontrun{
identifier <- "A-Day-In-The-Life"
key <- "your token"
artist <- "the-beatles"
type <- "name"
lyrics(identifier, type, artist, key)

key <- "your token"
identifier <- "3ade68b4gdc96eda3"
type <- "id"
lyrics(identifier = identifier, type = type, key = key)
}
}
\author{
Bruna Wundervald, \email{brunadaviesw@gmail.com}.
}
