% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkers.R
\name{type-checkers}
\alias{type-checkers}
\title{Type checkers}
\arguments{
\item{\dots}{Check items, i.e., formulae that are one-sided or have a string
as left-hand side (see \emph{Check Formulae of Local Scope} in the
documentation page \link{firmly}). These are the expressions to check.}
}
\value{
Check formula of local scope.
}
\description{
These functions make check formulae of local scope based on the
correspondingly named (atomic) type predicate from \pkg{base} R.
}
\details{
Each function \code{vld_*} is a function of class
\code{"check_maker"}, generated by \code{\link{localize}}.
}
\examples{
\dontrun{

f <- function(x, y) "Pass"

# Impose a check on x: ensure it's of type "logical"
f_firm <- firmly(f, vld_logical(~x))
f_firm(TRUE, 0)  # [1] "Pass"
f_firm(1, 0)     # Error: "Not logical: x"

# Use a custom error message
f_firm <- firmly(f, vld_logical("x should be a logical vector" ~ x))
f_firm(1, 0)     # Error: "x should be a logical vector"

# To impose the same check on all arguments, apply globalize()
f_firmer <- firmly(f, globalize(vld_logical))
f_firmer(TRUE, FALSE)  # [1] "Pass"
f_firmer(TRUE, 0)      # Error: "Not logical: `y`"
f_firmer(1, 0)         # Errors: "Not logical: `x`", "Not logical: `y`"
}
}
\alias{vld_character}
\alias{vld_complex}
\alias{vld_double}
\alias{vld_integer}
\alias{vld_logical}
\alias{vld_raw}
\usage{
vld_character(...)

vld_complex(...)

vld_double(...)

vld_integer(...)

vld_logical(...)

vld_raw(...)
}
\seealso{
Corresponding predicates: \code{\link[base]{is.character}}, \code{\link[base]{is.complex}}, \code{\link[base]{is.double}}, \code{\link[base]{is.integer}}, \code{\link[base]{is.logical}}, \code{\link[base]{is.raw}}

\code{\link{globalize}} recovers the underlying check formula of global scope.

The notions of \dQuote{scope} and \dQuote{check item} are explained in the \emph{Check Formulae} section of \link{firmly}.

Other checkers: \link{scalar-checkers}, \link{misc-checkers}
}
