% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syntax.R
\name{exists_any}
\alias{exists_any}
\alias{exists_one}
\title{Test for (unique) existence}
\usage{
exists_any(rule, ..., na.rm = FALSE)

exists_one(rule, ..., na.rm = FALSE)
}
\arguments{
\item{rule}{\code{[expression]} A validation rule}

\item{...}{A comma-separated list of variables used to group the data.}

\item{na.rm}{\code{[logical]} Toggle to ignore results that yield \code{NA}.}
}
\value{
A \code{logical} vector, with the same number of entries as there
are rows in the entire data under scrutiny. If a test fails, all records in
the group are labeled with \code{FALSE}.
}
\description{
Group records according to (zero or more) classifying variables.  Test for
each group whether at least one (\code{exists}) or precisely one
(\code{exists_one}) record satisfies a condition.
}
\examples{
# Test whether each household has exactly one 'head of household'

dd <- data.frame(
   hhid   = c(1,  1,  2,  1,  2,  2,  3 )
 , person = c(1,  2,  3,  4,  5,  6,  7 )
 , hhrole = c("h","h","m","m","h","m","m")
)
v <- validator(exists_one(hhrole=="h", hhid))
values(confront(dd, v))

# same, but now with missing value in the data
dd <- data.frame(
    hhid   = c(1,  1,  2,  1,  2,  2,  3 )
  , person = c(1,  2,  3,  4,  5,  6,  7 )
  , hhrole = c("h",NA,"m","m","h","m","h")
)
values(confront(dd, v))

# same, but now we ignore the missing values
v <- validator(exists_one(hhrole=="h", hhid, na.rm=TRUE))
values(confront(dd, v))

}
\seealso{
Other cross-record-helpers: 
\code{\link{is_complete}()},
\code{\link{is_unique}()}
}
\concept{cross-record-helpers}
