% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help_for_data_objects.R
\docType{data}
\name{financials_BZ2016}
\alias{financials_BZ2016}
\title{BZ2016 financial processes}
\format{A list with elements:
\describe{
\item{[[1]]}{List of parameters for \code{\link[yuima]{simulate}}}
\item{[[2]]}{List of parameters for \code{\link{setModel}}}
\item{[[3]]}{Vector with indices indicating the interest rate and log price
in solve.variable \code{\link{setModel}}}
}}
\usage{
financials_BZ2016
}
\description{
List of parameters to initialize a \code{\link{va_sde_engine2}} object to
simulate the interest rate and log price processes being the
volatility constant. The interest rate and fund processes
follow the stochastic differential equations specified
in BMOP2011 -  See \bold{References}. The volatility is constant with
default value 0.2
}
\examples{
 #Sets the constant volatility to 0.3
 financials_BZ2016[[1]]$K <- 0.3 ^ 2

}
\references{
\enumerate{
\item{[BMOP2011]}{
 \cite{Bacinello A.R., Millossovich P., Olivieri A. e Pitacco E.
       "Variable annuities: a unifying valuation approach."
        In: Insurance: Mathematics and Economics 49 (2011), pp. 285-297.}
      }
 }
}
\keyword{datasets}
