% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CleanProteinStructures.R
\name{CleanProteinStructures}
\alias{CleanProteinStructures}
\title{Clean Protein Structures}
\usage{
CleanProteinStructures(prefix = "./alignTesting", CleanHydrogenAtoms = TRUE,
  CleanModeledAtoms = TRUE, cutoff.prot.h2o.dist = 6, min.num.h2o = 20,
  cleanDir = "ProteinSystem", filename = "ProteinSystem")
}
\arguments{
\item{prefix}{The directory with the PDB files to be cleaned}

\item{CleanHydrogenAtoms}{A logical indication if hydrogen atoms should be
removed; default: \code{TRUE}}

\item{CleanModeledAtoms}{A logical indication if modeled atoms should be
removed; default: \code{TRUE}}

\item{cutoff.prot.h2o.dist}{A numerical value setting the maximum distance
between a protein atom (heteroatoms are ignored) and water oxygen atoms.
The oxygen atoms equal to or less than this distance are retained;
default: \code{6.0} Angstroms}

\item{min.num.h2o}{Minimum number of water oxygen atoms within a protein
structure for it to be included in the conserved water analysis;
default: 20}

\item{cleanDir}{A character string for the "cleaned" PDB structures to be
written. The provided character string are appended with "_CLEANED";
default: \code{"ProteinSystem"}}

\item{filename}{The filename prefix for the returned results. Default is
"ProteinSystem"}
}
\value{
The following data is returned:
\itemize{
\item \strong{cleaning.summary}: summary indicating
\itemize{
\item if hydrogen atoms were removed \code{TRUE/FALSE}
\item number of out of range atoms for B-values and occupancy values
\item number of modeled (and thus removed)
\item number of atoms \emph{\strong{NOT}} modeled (and thus retained)
\item number of water oxygen atoms beyond the user defined cutoff
\item the number of water oxygen atoms within the user defined cutoff.
}
\item \strong{Bvalue.counts}: binned B-value values with binwidths = 5 (0 to 100)
\item \strong{normBvalue.counts}: binned normalized B-value values with binwidths
= 0.1 (-4 to 6)
\item \strong{occupancy.counts}: binned occupancy values with binwidths = 0.1 (0 to
1)
\item \strong{mobility.counts}: binned mobility values with binwidths = 0.1 (0 to 6)
\item \strong{Excel workbook}: containing the cleaning.summary, Bvalue.counts,
normBvalue.counts, occupancy.counts, and mobility.counts
data as individual tabs
\item \strong{PDBids.retained}: a vector of PDBids
\item \strong{call}: parameters provided by the user
}
}
\description{
Removes hydrogen and modeled atoms from a RCSB/PDB structure
along with waters beyond a user defined distance from protein atoms.
}
\details{
PDB files obtained from the PDB conform to a specific set of
formatting standards but this does not mean the data within the PDB files
is always correct. This function \emph{cleans} the PDB file and summaries the
atom evaluations.

This function does the following (in this order):
\itemize{
\item Reads in the PDB file
\item Adds/updates the element symbol (\code{elesy}) using the atom type (\code{elety})
via the \code{\link[bio3d:atom2ele]{bio3d::atom2ele()}} function
\item Removes hydrogen atoms via \code{\link[=RemoveHydrogenAtoms]{RemoveHydrogenAtoms()}} (user option)
\item Removes atoms with occupancy values determined to be out of range (OoR)
via \code{\link[=RemoveOoR.o]{RemoveOoR.o()}}
\item Removes atoms with B-values determined to be out of range (OoR)
via \code{\link[=RemoveOoR.b]{RemoveOoR.b()}}
\item Bins (counts) the occupancy values
\item Bins (counts) the B-values
\item Bins (counts) the normalized B-values
\item Bins (counts) the mobility values
\item Removes modeled atoms via \code{\link[=RemoveModeledAtoms]{RemoveModeledAtoms()}} (user option)
\item Removes water oxygen atoms greater than user defined value
\code{cutoff.prot.h2o.dist} from the protein via \code{\link[=RetainWatersWithinX]{RetainWatersWithinX()}}
(user option)
\item Writes cleaned protein structure to a PDB file
}
}
\seealso{
Other "Clean Protein Structure": \code{\link{RemoveHydrogenAtoms}},
  \code{\link{RemoveModeledAtoms}},
  \code{\link{RemoveOoR.b}}, \code{\link{RemoveOoR.o}},
  \code{\link{RetainWatersWithinX}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
