% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{nBvalueBarplot}
\alias{nBvalueBarplot}
\title{Normalized B-value Barplots}
\usage{
nBvalueBarplot(data, passed.waters = TRUE)
}
\arguments{
\item{data}{The \code{h2o.clusters.summary} data.frame from the
\code{\link[=ClusterWaters]{ClusterWaters()}} function containing the \code{nBvalue.mu}
information.}

\item{passed.waters}{Logical indicator to plot results for waters \strong{passing}
\code{\link[=Mobility]{Mobility()}} and \code{\link[=NormalizedBvalue]{NormalizedBvalue()}} \emph{\strong{OR}} using \strong{all} waters within
the \code{PDB} files.}
}
\description{
Normalized B-value Barplots for Cluster with at least 50\%
Conservation
}
\details{
Constructs a barplot with corresponding density plot for the mean
normalized B-value value for all water within each cluster with at least
50\% water conservation. Clusters with 50 to 69\% water conseration are dark
red, clusters with 70 to 79\% conservation are red, 80 to 89\% conservation
are light blue, 90 to 99\% conservation are blue, and 100\% conservation
(waters from all structures) are dark blue.

The normalized B-value values are calculated by the
\code{\link[=NormalizedBvalue]{NormalizedBvalue()}} function.

This plot was inspired by Figure 1 of Sanschagrin and Kuhn (1998).
}
\examples{
  \dontrun{
  nBvalue.plot <- nBvalueBarplot(data=thrombin10.conservedWaters,
                                 passed.waters=TRUE)
  }

}
\references{
Paul C Sanschagrin and Leslie A Kuhn. Cluster analysis of
consensus water sites in thrombin and trypsin shows conservation between
serine proteases and contributions to ligand specificity. \emph{Protein
Science}, 1998, \strong{7} (\emph{10}), pp 2054-2064.
\href{http://doi.org/10.1002/pro.5560071002}{DOI: 10.1002/pro.5560071002}
\href{http://www.ncbi.nlm.nih.gov/pubmed/9792092}{PMID: 9792092}
\href{http://www.kuhnlab.bmb.msu.edu/software/watch/index.html}{WatCH webpage}
}
\seealso{
Other plots: \code{\link{BoundWaterEnvPlots}},
  \code{\link{BoundWaterEnvSummaryPlot}},
  \code{\link{BvalueBarplot.summ}},
  \code{\link{BvalueBarplot}},
  \code{\link{ClusterSummaryPlots}},
  \code{\link{MobNormBvalEvalPlots}},
  \code{\link{MobilityBarplot.summ}},
  \code{\link{MobilityBarplot}},
  \code{\link{OccupancyBarplot.summ}},
  \code{\link{OccupancyBarplot}},
  \code{\link{normBvalueBarplot.summ}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
