% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CleanProteinStructures.R
\name{RetainWatersWithinX}
\alias{RetainWatersWithinX}
\title{Retain Waters Within X Angstroms of Protein}
\usage{
RetainWatersWithinX(atoms.dist, prot.het.h2o.idc, cutoff.prot.h2o.dist)
}
\arguments{
\item{atoms.dist}{Atomic distances calculated with the \code{\link[stats:dist]{stats::dist()}}
function}

\item{prot.het.h2o.idc}{List of protein, HET-atom, and water atom indices}

\item{cutoff.prot.h2o.dist}{User defined maximum numerical distance, in
Angstroms, between the protein and water oxygen atoms to be retained.}
}
\value{
numerical vector of water oxygen atom indicies to retain
}
\description{
Retains water oxygen atoms within a user defined distance
}
\details{
Retain water oxygen atoms within a user defined distance. This
function is a coarse grain method of removing waters beyond a predefined
distance to reduce the computational load associated with the
\code{\link[stats:dist]{stats::dist()}} function for a collection of protein structure.
}
\examples{
  \donttest{
  ##--- determine the protein, hetatom, and  water indices
  prot.het.h2o.idc <- ProtHetWatIndices(data=PDB.1hah.aoi.clean)

  ##--- calculate the distances
  atoms.dist <- as.matrix(dist(PDB.1hah.aoi.clean[, c("x","y","z")],
                               method="euclidean",
                               diag=TRUE, upper=TRUE))
  diag(atoms.dist) <- NA

  water.idc.within.6 <- RetainWatersWithinX(atoms.dist,
                                            prot.het.h2o.idc,
                                            cutoff.prot.h2o.dist=6.0)
  # - 204 of the 204 water oxygen atoms are within 6 Angstroms of the protein
  }

}
\seealso{
Other "Clean Protein Structure": \code{\link{CleanProteinStructures}},
  \code{\link{RemoveHydrogenAtoms}},
  \code{\link{RemoveModeledAtoms}},
  \code{\link{RemoveOoR.b}}, \code{\link{RemoveOoR.o}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\concept{"Clean Protein Structure"}
