% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vapour-helpers.R
\name{vapour_geom_summary}
\alias{vapour_geom_summary}
\title{Summary of available geometry}
\usage{
vapour_geom_summary(
  dsource,
  layer = 0L,
  sql = "",
  limit_n = NULL,
  skip_n = 0,
  extent = NA
)
}
\arguments{
\item{dsource}{data source name (path to file, connection string, URL)}

\item{layer}{integer of layer to work with, defaults to the first (0) or the name of the layer}

\item{sql}{if not empty this is executed against the data source (layer will be ignored)}

\item{limit_n}{an arbitrary limit to the number of features scanned}

\item{skip_n}{an arbitrary number of features to skip}

\item{extent}{apply an arbitrary extent, only when 'sql' used (must be 'ex = c(xmin, xmax, ymin, ymax)' but sp bbox, sf bbox, and raster extent also accepted)}
}
\value{
list containing the following
\itemize{
\item \code{FID} the feature id value (an integer, usually sequential)
\item \code{valid_geometry} logical value if a non-empty geometry is available
\item \code{type} integer value of geometry type from \href{https://gdal.org/doxygen/ogr__core_8h.html#a800236a0d460ef66e687b7b65610f12a}{GDAL enumeration}
\item \verb{xmin, xmax, ymin, ymax} numeric values of the extent (bounding box) of each geometry
}
}
\description{
Read properties of geometry from a source, optionally after SQL execution.
}
\details{
Use \code{limit_n} to arbitrarily limit the number of features queried.
}
\examples{
file <- "list_locality_postcode_meander_valley.tab"
mvfile <- system.file(file.path("extdata/tab", file), package="vapour")
vapour_geom_summary(mvfile, limit_n = 3L)

gsum <- vapour_geom_summary(mvfile)
plot(NA, xlim = range(c(gsum$xmin, gsum$xmax), na.rm = TRUE),
         ylim = range(c(gsum$ymin, gsum$ymax), na.rm = TRUE))
rect(gsum$xmin, gsum$ymin, gsum$xmax, gsum$ymax)
text(gsum$xmin, gsum$ymin, labels = gsum$FID)
}
