% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster-input.R
\name{vapour_read_raster}
\alias{vapour_read_raster}
\title{Raster IO (read)}
\usage{
vapour_read_raster(
  x,
  band = 1,
  window,
  resample = "nearestneighbour",
  ...,
  sds = NULL,
  native = FALSE,
  set_na = TRUE
)
}
\arguments{
\item{x}{data source}

\item{band}{index of which band to read (1-based)}

\item{window}{src_offset, src_dim, out_dim}

\item{resample}{resampling method used (see details)}

\item{...}{reserved}

\item{sds}{index of subdataset to read (usually 1)}

\item{native}{apply the full native window for read, \code{FALSE} by default}

\item{set_na}{specify whether NA values should be set for the NODATA}
}
\value{
list of numeric vectors (only one for 'band')
}
\description{
Read a window of data from a GDAL raster source. The first argument is the source
name and the second is a 6-element \code{window} of offset, source dimension, and output dimension.
}
\details{
The value of \code{window} may be input as only 4 elements, in which case the source dimension
Will be used as the output dimension.

This is analogous to the \code{rgdal} function \code{readGDAL} with its arguments \code{offset},  \code{region.dim}
and \code{output.dim}.  There's no semantic wrapper for this in vapour, but see
\verb{https://github.com/hypertidy/lazyraster} for one approach.

Resampling options will depend on GDAL version,  but currently  'NearestNeighbour' (default),
'Average', 'Bilinear', 'Cubic', 'CubicSpline',  'Gauss', 'Lanczos', 'Mode' are potentially
available. These are compared internally by converting to lower-case. Detailed use of this is barely tried or tested with vapour, but is
a standard facility used in GDAL. Easiest way to compare results is with gdal_translate.

There is no write support in vapour.

Currently the \code{window} argument is required. If this argument unspecified and \code{native = TRUE} then
the default window specification will be used, the entire extent at native resolution. If 'window'
is specified and \code{native = TRUE} then the window is used as-is, with a warning (native is ignored).
}
\examples{
f <- system.file("extdata", "sst.tif", package = "vapour")
## a 5*5 window from a 10*10 region
vapour_read_raster(f, window = c(0, 0, 10, 10, 5, 5))
vapour_read_raster(f, window = c(0, 0, 10, 10, 5, 5), resample = "Lanczos")
## find the information first
ri <- vapour_raster_info(f)
str(matrix(vapour_read_raster(f, window = c(0, 0, ri$dimXY, ri$dimXY)), ri$dimXY[1]))
## the method can be used to up-sample as well
str(matrix(vapour_read_raster(f, window = c(0, 0, 10, 10, 15, 25)), 15))

}
