% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{vm_diagnostics}
\alias{vm_diagnostics}
\title{Plot diagnostics from a VM model}
\usage{
vm_diagnostics(object, plot = TRUE, ...)
}
\arguments{
\item{object}{Results from running \code{varian}.}

\item{plot}{Logical whether to plot the results or just return the grob
for the plots.  Defaults to \code{TRUE}.}

\item{\dots}{Additional arguments not currently used}
}
\value{
A graphical object
}
\description{
This function plots a variety of diagnostics from a Variability Model.
These include a histogram of the Rhat values (so-called percent scale reduction
factors).  An Rhat value of 1 indicates that no reduction in the variability of
the estimates is possible from running the chain longer.  Values below 1.10 or 1.05
are typically considered indicative of convergence, with higher values indicating
the model did not converge and should be changed or run longer.
A histogram of the effective sample size indicates for every parameter estimated how
many effective posterior samples are available for inference.  Low values may indicate
high autocorrelation in the samples and may be a sign of failure to converge.
The maximum possible will be the total iterations available.
Histograms of the posterior medians for the latent variability and intercept estimates
are also shown.
}
\examples{
# Make Me!
}
\author{
Joshua F. Wiley <josh@elkhartgroup.com>
}
\keyword{hplot}

