% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.ides.file.R
\name{merge.ides.annotation}
\alias{merge.ides.annotation}
\title{Merge potential iDES calls with variant annotation.}
\usage{
\method{merge}{ides.annotation}(ides.filename, output = TRUE,
  output.suffix = ".ann.txt",
  annovar.suffix.pattern = ".annovar.hg(\\\\d{2})_multianno.txt")
}
\arguments{
\item{ides.filename}{Path to formatted iDES output (typically from convert.ides.output file)}

\item{output}{Logical indicating whether output should be saved to file. Defaults to true.}

\item{output.suffix}{Suffix to be appended to input filename if saving results to file}

\item{annovar.suffix.pattern}{Suffix to match ANNOAR file}
}
\value{
annotated.calls Data frame of annotations and iDES output.
}
\description{
Merge potential iDES calls with variant annotation.
}
\details{
The VarDict variant calling includes a GATK call merging the call vcf file (allele frequency information etc.) with
the ANNOVAR annotation, and saving the result as a table. This function is an attempt to emulate that step 
for the iDES calls.
}
